/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/src/java/com/sun/enterprise/management/support/BulkAccessImpl.java,v 1.3 2005/12/25 03:40:38 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:40:38 $
 */

package com.sun.enterprise.management.support;

import javax.management.ObjectName;
import javax.management.MBeanInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;

import javax.management.Attribute;
import javax.management.AttributeList;

import com.sun.appserv.management.base.BulkAccess;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.util.jmx.JMXUtil;


/**
 */
public class BulkAccessImpl extends AMXImplBase
	implements BulkAccess
{
		public
	BulkAccessImpl()
	{
	}

		public String
	getGroup()
	{
		return( AMX.GROUP_UTILITY );
	}
	
		public Object[]
	bulkGetMBeanInfo( final ObjectName[] objectNames )
	{
		final Object[]	infos	= new Object[ objectNames.length ];
		
		for( int i = 0; i < infos.length; ++i )
		{
			try
			{
				infos[ i ]	= getMBeanServer().getMBeanInfo( objectNames[ i ] );
			}
			catch( Throwable t )
			{
				infos[ i ]	= t;
			}
		}
		return( infos );
	}
	
		public Object[]
	bulkGetMBeanAttributeInfo( final ObjectName[] objectNames )
	{
		final Object[]	results		= new Object[objectNames.length];
		final Object[]	mbeanInfos	= bulkGetMBeanInfo( objectNames );
		
		for( int i = 0; i < results.length; ++i )
		{
			if ( mbeanInfos[ i ] instanceof MBeanInfo )
			{
				results[ i ]	= ((MBeanInfo)mbeanInfos[ i ]).getAttributes();
			}
			else
			{
				results[ i ]	= mbeanInfos[ i ];
			}
		}
		return( results );
	}
	
		public Object[]
	bulkGetAttributeNames( final ObjectName[] objectNames )
	{
		final Object[]	results		= new Object[ objectNames.length ];
		final Object[]	mbeanInfos	= bulkGetMBeanInfo( objectNames );
		
		for( int i = 0; i < results.length; ++i )
		{
			if ( mbeanInfos[ i ] instanceof MBeanInfo )
			{
				final MBeanInfo	info	= (MBeanInfo)mbeanInfos[ i ];
				
				results[ i ]	= JMXUtil.getAttributeNames( info.getAttributes() );
			}
			else
			{
				results[ i ]	= mbeanInfos[ i ];
			}
		}
		return( results );
	}
	
		public Object[]
	bulkGetMBeanOperationInfo( final ObjectName[] objectNames )
	{
		final Object[]	results	= new Object[ objectNames.length ];
		final Object[]	mbeanInfos	= bulkGetMBeanInfo( objectNames );
		
		for( int i = 0; i < results.length; ++i )
		{
			if ( mbeanInfos[ i ] instanceof MBeanInfo )
			{
				final MBeanInfo	info	= (MBeanInfo)mbeanInfos[ i ];
				
				results[ i ]	= info.getOperations();
			}
			else
			{
				results[ i ]	= mbeanInfos[ i ];
			}
		}
		return( results );
	}
	
		public Object[]
	bulkGetAttribute(
		final ObjectName[]	objectNames,
		final String		attributeName )
	{
		final Object[]	results	= new Object[ objectNames.length ];
		
		for( int i = 0; i < objectNames.length; ++i )
		{
			try
			{
				results[ i ]	= getMBeanServer().getAttribute( objectNames[ i ], attributeName );
			}
			catch( Throwable t )
			{
				results[ i ]	= t;
			}
		}
		return( results );
	}
	
		public Object[]
	bulkSetAttribute(
		final ObjectName[]	objectNames,
		final Attribute		attr )
	{
		final Object[]	results	= new Object[ objectNames.length ];
		
		for( int i = 0; i < objectNames.length; ++i )
		{
			try
			{
				results[ i ]	= null;
				getMBeanServer().setAttribute( objectNames[ i ], attr );
			}
			catch( Throwable t )
			{
				results[ i ]	= t;
			}
		}
		return( results );
	}
	
	
		public Object[]
	bulkGetAttributes(
		final ObjectName[]	objectNames,
		final String[]		attributeNames )
	{
		final Object[]	results	= new Object[ objectNames.length ];
		
		// check for empty list; this occurs occassionally and not all MBeans
		// are well-behaved if one asks for an empty list
		if ( attributeNames.length != 0 )
		{
			for( int i = 0; i < objectNames.length; ++i )
			{
				// copy names, in case an MBean messes with the array
				final String[]	attributesCopy	= (String[])attributeNames.clone();
				
				try
				{
					results[ i ]	= getMBeanServer().getAttributes( objectNames[ i ], attributesCopy );
				}
				catch( Throwable t )
				{
					results[ i ]	= t;
				}
			}
		}
		return( results );
	}
	
	
		public Object[]
	bulkSetAttributes(
		final ObjectName[]	objectNames,
		final AttributeList	attrs )
	{
		final Object[]	results	= new Object[ objectNames.length ];
		
		for( int i = 0; i < objectNames.length; ++i )
		{
			try
			{
				// avoid alterations to original copy
				final AttributeList	attrsCopy	= (AttributeList)attrs.clone();
				
				results[ i ]	= getMBeanServer().setAttributes( objectNames[ i ], attrsCopy );
			}
			catch( Throwable t )
			{
				results[ i ]	= t;
			}
		}
		return( results );
	}
	
	
		public Object[]
	bulkInvoke(
		final ObjectName[]	objectNames,
		final String		operationName,
		final Object[]		args,
		final String[]		types )
	{
		final Object[]	results	= new Object[ objectNames.length ];
		
		for( int i = 0; i < objectNames.length; ++i )
		{
			try
			{
				// hopefully the MBean won't alter the args or types
				results[ i ]	= getMBeanServer().invoke( objectNames[ i ],
									operationName, args, types );
			}
			catch( Throwable t )
			{
				results[ i ]	= t;
			}
		}
		return( results );
	}
}











