/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.support;

import java.util.logging.Level;

import javax.management.ObjectName;

import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.XTypes;

import com.sun.appserv.management.util.misc.ExceptionUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;


import com.sun.enterprise.management.monitor.CallFlowMonitorImpl;

/**
	Implements loading of all MBean API MBeans in non-DAS instances.
 */
public final class NonDASLoader extends LoaderBase
    implements NonDASLoaderMBean
{
		public
	NonDASLoader()
	{
	    debug( "NonDASLoader" );
	}
	
	/**
	    @Override
	 */
		protected void
	startHook()
	{
	    debug( "startHook" );
	}
	
	/**
	    @Override
	 */
	    protected Object
    createDomainRoot()
    {
	    debug( "createDomainRoot" );
        return null;
    }
    
    
	/**
	    @Override
	 */
	    public boolean
	isDAS()
	{
	    return false;
	}
	
	    private void
	loadCallFlowMonitor()
	{
	    try
	    {
	        final CallFlowMonitorImpl   callFlow    = new CallFlowMonitorImpl();
	        
	        final String serverName = BootUtil.getInstance().getServerName();
	        String props  = Util.makeRequiredProps( XTypes.CALL_FLOW_MONITOR, serverName );
	        props   = Util.concatenateProps( props,
	                    Util.makeProp( XTypes.SERVER_ROOT_MONITOR, serverName ) );
	        
	        final ObjectName  proposedName  = Util.newObjectName(
	                            BootUtil.getInstance().getAMXJMXDomainName(), props );
	                            
			final ObjectName objectName =
			    getMBeanServer().registerMBean( callFlow, proposedName ).getObjectName();
			debug( "Loaded CallFlowMonitor as " + JMXUtil.toString( objectName ) );
			
	    }
	    catch( Exception e )
	    {
	        final Throwable rootCause   = ExceptionUtil.getRootCause(e);
	        final String msg = "Exception creating/loading CallFlowMonitor: " +
	             rootCause + ", msg=" + rootCause.getMessage();
	        debug( msg );
	        getMBeanLogger().log( Level.WARNING, msg, rootCause );
	    }
	}
	
	    private void
	loadSpecialtyMBeans()
	{
	    debug( "loadSpecialtyMBeans" );
	    loadCallFlowMonitor();
	}
	
	/**
	    @Override
	 */
	    public void
	adminServiceReady()
	{
	    debug( "adminServiceReady" );
	    loadSpecialtyMBeans();
	}
	
}

























