/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
 
/*
 */

package com.sun.enterprise.management.support;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;

import javax.management.ObjectName;
import javax.management.MBeanServer;
import javax.management.JMException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.SystemInfo;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.jmx.JMXUtil;

/**
 */
public final class SystemInfoImpl extends AMXImplBase
	implements SystemInfo
{
	private final MBeanServer	mServer;
	
	private BootUtil	mBootUtil;
	
	public static final String	NAME_PROP_VALUE	= "system-info";
	
	private final Map<String,Boolean>	mFeatures;
	
		private final boolean
	supportsClusters( )
	{
		final ObjectName	serversObjectName	= getOldServersMBeanObjectName();
		
		boolean	supportsClusters	= false;
		if ( serversObjectName != null )
		{
			// see if the 'servers' MBean supports listing unclustered instances
			try
			{
				final MBeanInfo				info	= mServer.getMBeanInfo( serversObjectName );
				
				final String	operationName	= "listUnclusteredServerInstancesAsString";
				final Set	operations	= JMXUtil.findInfoByName( info.getOperations(), operationName );
				supportsClusters	= operations.size() != 0;
				
			}
			catch( JMException e )
			{
				// should never happen...
				throw new RuntimeException( "problem with 'servers' MBean: " + serversObjectName, e );
			}
		}
		else
		{
			// presumably, we're in another instance, which implies multiple instances.
			// assume this also means clustering is possible
			supportsClusters	= true;
		}
		
		return( supportsClusters );
	}
	
	/**
		Get the ObjectName of the "type=servers" MBean, which only exists in the DAS.
	 */
		private ObjectName
	getOldServersMBeanObjectName()
	{
		// if we find the old "servers" MBean, it should only be running in the DAS.
		final ObjectName	pattern		=
				Util.newObjectName( "com.sun.appserv", "category=config,type=servers" );
		final Set<ObjectName> serversSet	= JMXUtil.queryNames( mServer, pattern, null );
		
		final ObjectName	objectName	= serversSet.size() == 0 ? 
					null : (ObjectName)GSetUtil.getSingleton( serversSet );
					
		return( objectName );
	}
	
		private boolean
	isRunningInDomainAdminServer()
	{
		return( getOldServersMBeanObjectName() != null );
	}
	
		public
	SystemInfoImpl(
		final MBeanServer	server,
		final BootUtil		bootUtil )
	{
		super( );
		
		mServer			= server;
		mBootUtil		= bootUtil;
		
		mFeatures	= new HashMap<String,Boolean>();
		
		final boolean	supportsClusters	= supportsClusters( );
		
		mFeatures.put( CLUSTERS_FEATURE, Boolean.valueOf( supportsClusters ));
		mFeatures.put( MULTIPLE_SERVERS_FEATURE, Boolean.valueOf( supportsClusters ));
		mFeatures.put( RUNNING_IN_DAS_FEATURE, Boolean.valueOf( isRunningInDomainAdminServer() ) );
	}
	
		public final String
	getGroup()
	{
		return( AMX.GROUP_UTILITY );
	}
	
	private static final String[] FEATURE_NAMES	=
		new String[]
		{
			CLUSTERS_FEATURE,
			MULTIPLE_SERVERS_FEATURE,
			RUNNING_IN_DAS_FEATURE,
		};
	
		public String[]
	getFeatureNames()
	{
		return( (String[])FEATURE_NAMES.clone() );
	}
	
		public boolean
	supportsFeature( final String key )
	{
		boolean	supports	= false;
		
		Boolean	result	= mFeatures.get( key );
		if ( result == null )
		{
			result	= Boolean.FALSE;
		}
		
		return( result.booleanValue() );
	}
	
}








