/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management;

import javax.management.MBeanServerInvocationHandler;
import javax.management.ObjectName;

import java.util.Set;
import java.util.Map;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.util.misc.ExceptionUtil;

import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.JavaConfig;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.appserv.management.config.AdminServiceConfig;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ExceptionUtil;

import com.sun.enterprise.management.config.*;
import com.sun.enterprise.management.support.AMXDebugStuff;
import com.sun.enterprise.management.support.AMXDebugSupportMBean;


/**
    This test run prior to testing any AMX MBeans.
 */
public final class RunMeFirstTest extends AMXTestBase
{
		public
	RunMeFirstTest( )
	{
	    initCoverageInfos();
	}
	
	    private void
	initCoverageInfos()
	{
	    final Set<AMX>  all = getAllAMX();
	    
	    // set the AMX-DEBUG flags on
	    final String AMX_DEBUG  = "-DAMX-DEBUG.enabled=true";
	    final String AMX_DEBUG2  = "-DAMX-DEBUG=true";
	    
	    // set AMX-DEBUG.enabled=true in all ConfigConfig JVM options
	    final Map<String,ConfigConfig> configs = getDomainConfig().getConfigConfigMap();
	    for( final ConfigConfig config : configs.values() )
	    {
	        final JavaConfig jc = config.getJavaConfig();
	        final Set<String>   jvmOptions  = GSetUtil.newStringSet( jc.getJVMOptions() );
	        
	        if ( ! ( jvmOptions.contains( AMX_DEBUG ) || jvmOptions.contains( AMX_DEBUG2 ) ))
	        {
	            jvmOptions.add( AMX_DEBUG );
	            jc.setJVMOptions( GSetUtil.toStringArray( jvmOptions ) );
	            
	            // don't warn for default-config; it's not used by a running server
	            if ( ! config.getName().equals( "default-config" ) )
	            {
    	            warning( "Enabled AMX-DEBUG for config " + config.getName()+
    	                " (restart required)" );
	            }
	        }
	    }
	    
	    // setup default stuff
	    final AMXDebugSupportMBean debug    = getAMXDebugSupportMBean();
	    debug.setAll( true );
	    debug.setDefaultDebug( true );
	    debug.getOutputIDs();
	    
	    for( final AMX amx : all )
	    {
	        final AMXDebugStuff debugStuff  = getTestUtil().asAMXDebugStuff( amx );
	        
	        if ( debugStuff == null )
	        {
	            continue;
	        }
	        
	        try
	        {
                debugStuff.enableAMXDebug( true );
            }
            catch( Throwable t )
            {
                warning( "Couldn't enableAMXDebug() for " + amx.getJ2EEType() );
            }
            
	        try
	        {
                debugStuff.enableCoverageInfo( true );
                debugStuff.clearCoverageInfo();
            }
            catch( Throwable t )
            {
                warning( "Couldn't enableCoverageInfo for " + amx.getJ2EEType() );
            }
	    }
	}
}














