/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management;

import java.io.File;
import java.io.PrintStream;

import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import java.util.Arrays;


import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.base.AMX;

import com.sun.appserv.management.helper.RefHelper;

import com.sun.appserv.management.util.misc.StringUtil;

import com.sun.enterprise.management.TestUtil;
import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;
import com.sun.enterprise.management.config.DanglingRefsTest;
import com.sun.enterprise.management.support.CoverageInfo;


/**
    This test should normally be run before the generic tests
    so that it can set up default items for many of the config elements
    so that the generic tests will actually test them. Otherwise,
    when the generic tests are run, they won't see any instances
    of many of the AMXConfig MBeans.
    <p>
    If there are errors doing this, disable this test in amxtest.classes,
    fix the error in the specific place it's occurring, then re-enabled
    this test.
 */
public final class RunMeLastTest extends AMXTestBase
{
		public
	RunMeLastTest( )
	{
	}
	
	    private void
	emitCoverage()
	    throws java.io.IOException
	{
	    final CoverageInfoAnalyzer  analyzer = 
	        new CoverageInfoAnalyzer( getDomainRoot() );
	    
	    final String summary    = analyzer.getCoverageSummary();
	    
	    final File  dataFile    = new File ("amx-tests.coverage");
	    final PrintStream  out = new PrintStream( dataFile );
	    out.println( summary );
	    out.close();
    
    	if ( getVerbose() )
        {
            trace( "NOTE: code coverage data save in file " +
                StringUtil.quote( "" + dataFile ) );
        }
	}
	
	    public void
	testLast()
	    throws Exception
	{
	    emitDanglingRefs();
	    
	    if ( getTestUtil().asAMXDebugStuff( getDomainRoot() ) != null )
	    {
	        emitCoverage();
	    }
	}
	
	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( true );
	}
	
	
	    public void
	emitDanglingRefs()
	    throws ClassNotFoundException
	{
	    new DanglingRefsTest().testAllDangling();
	}
}

















