/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/JMXConnectorConfigTest.java,v 1.6 2006/03/09 20:30:54 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:54 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;
import java.util.Set;

import javax.management.ObjectName;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Container;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.config.AMXConfig;
import com.sun.appserv.management.config.AdminServiceConfig;
import com.sun.appserv.management.config.DomainConfig;
import com.sun.appserv.management.config.ConfigConfig;
import com.sun.appserv.management.config.JMXConnectorConfig;
import com.sun.appserv.management.config.SSLConfig;
import com.sun.appserv.management.config.JMXConnectorConfigKeys;
import com.sun.appserv.management.config.PropertiesAccess;
import com.sun.appserv.management.config.SecurityServiceConfig;
import com.sun.appserv.management.config.AuthRealmConfig;

import com.sun.appserv.management.util.misc.MapUtil;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class JMXConnectorConfigTest extends ConfigMgrTestBase
{
	static final String ADDRESS	= "0.0.0.0";
	static final String TEST_REALM_CLASS	= "com.test.DUMMY";
	static final String DEFAULT_PORT    	= "17377";

	static final Map<String,String> OPTIONAL	= new HashMap<String,String>();

	static
	{
		OPTIONAL.put( PropertiesAccess.PROPERTY_PREFIX + "xyz", "abc");
		OPTIONAL.put( JMXConnectorConfigKeys.SECURITY_ENABLED_KEY, "false");
	}

		public
	JMXConnectorConfigTest()
	{
	    if ( checkNotOffline( "ensureDefaultInstance" ) )
	    {
	        ensureDefaultInstance( getConfigConfig().getAdminServiceConfig() );
	    }
	}
	
        public static String
    getDefaultInstanceName()
    {
        return getDefaultInstanceName( "JMXConnectorConfig" );
    }
    
	    public static JMXConnectorConfig
	ensureDefaultInstance( final AdminServiceConfig adminServiceConfig )
	{
	    JMXConnectorConfig   result  =
	        adminServiceConfig.getJMXConnectorConfigMap().get( getDefaultInstanceName() );
	    
	    if ( result == null )
	    {
	        final SecurityServiceConfig securityServiceConfig   =
	            getConfigConfig( adminServiceConfig ).getSecurityServiceConfig();
	            
	        final AuthRealmConfig defaultAuthRealm  =
	            AuthRealmConfigTest.ensureDefaultInstance( securityServiceConfig );
	        
	        result  = createInstance( getDefaultInstanceName(),
	            ADDRESS, DEFAULT_PORT, defaultAuthRealm, OPTIONAL );
	    }
	    
	    return result;
	}
	
	    public static JMXConnectorConfig
	createInstance(
	    final String name,
	    final String address,
	    final String    port,
	    final AuthRealmConfig authRealm,
	    final Map<String,String> optional )
	{
	    final AdminServiceConfig  adminServiceConfig =
	        getConfigConfig( authRealm ).getAdminServiceConfig();
	    
	    return adminServiceConfig.createJMXConnectorConfig( name,
	                address, port, authRealm.getName(), optional );
	}
	
	
	
		protected Container
	getProgenyContainer()
	{
		return getAdminServiceConfig();
	}

		protected String
	getProgenyJ2EEType()
	{
		return XTypes.JMX_CONNECTOR_CONFIG;
	}
	
	    final SecurityServiceConfig
	getSecurityServiceConfig()
	{
	    return getConfigConfig().getSecurityServiceConfig();
	}
	
	    final AuthRealmConfig
	createAuthRealmConfig( final String name )
	{
	    removeAuthRealmConfig( name );
	    
	    return getSecurityServiceConfig().createAuthRealmConfig(
	        name, TEST_REALM_CLASS, null );
	}
	
	    private String
	createAuthRealmName( final String progenyName )
	{
	    return progenyName + ".TestRealm";
	}
	
	    final void
	removeAuthRealmConfig( final String name )
	{
	    try
	    {
	        getSecurityServiceConfig().removeAuthRealmConfig( name );
	    }
	    catch( Exception e )
	    {
	    }
	}
    
		protected void
	removeProgeny( final String name )
	{
		try
		{
		    getAdminServiceConfig().removeJMXConnectorConfig( name );
		}
		finally
		{
	        try
	        {
	            removeAuthRealmConfig( createAuthRealmName( name ) );
	        }
	        catch( Exception e )
	        {
	        }
	    }
	}

		protected final AMXConfig
	createProgeny(
		final String name,
		final Map<String,String> options ) 
	{
		final Map<String,String>	allOptions	= MapUtil.newMap( options, OPTIONAL );
		
		final	int	port	= (name.hashCode() % 16000) + 33111;
		
		final String            authRealmName   = createAuthRealmName( name );
		final AuthRealmConfig   authRealmConfig = createAuthRealmConfig( authRealmName );
		
		try
		{
    	    return getAdminServiceConfig().createJMXConnectorConfig(name,
    	        ADDRESS, "" + port, authRealmName, allOptions);
	    }
	    catch( Exception e )
	    {
	        removeAuthRealmConfig( authRealmName );
	        throw new RuntimeException( e );
	    }
	}
	
		final AdminServiceConfig
	getAdminServiceConfig() 
	{
		return( getConfigConfig(). getAdminServiceConfig());
	}
	
		public void
	testCreateSSL()
		throws Exception
	{
	    if ( ! checkNotOffline( "testCreateSSL" ) )
	    {
	        return;
	    }
	    
		final String	NAME	= "JMXConnectorConfigTest-testCreateSSL";
		try
		{
			removeEx(NAME);
			final JMXConnectorConfig	newConfig	=
				(JMXConnectorConfig)createProgeny( NAME, null);
				
			final Map<String,JMXConnectorConfig>	jmxConnectors	=
				getAdminServiceConfig().getJMXConnectorConfigMap();
			
			final JMXConnectorConfig jmxConnector = (JMXConnectorConfig)
				jmxConnectors.get(NAME);
			assert jmxConnector != null;
			assert jmxConnector == newConfig;
			
			final String	CERT_NICKNAME	= NAME + "Cert";
			
			final SSLConfig ssl = jmxConnector.createSSLConfig( CERT_NICKNAME, null);
			assert ssl != null;
			assert ssl.getCertNickname().equals( CERT_NICKNAME );
			
			jmxConnector.removeSSLConfig();
		}
		finally
		{
			remove(NAME);
		}
	}
}


