/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.management.config;

import java.util.Set;

import javax.management.ObjectName;

import com.sun.appserv.management.base.AMX;
import com.sun.appserv.management.base.Util;

import com.sun.appserv.management.config.Libraries;

import com.sun.appserv.management.util.misc.GSetUtil;
import com.sun.appserv.management.util.misc.ArrayUtil;

import com.sun.appserv.management.config.WebModuleConfig;

import com.sun.enterprise.management.AMXTestBase;



/**
 */
public final class LibrariesTest extends AMXTestBase
{
    public LibrariesTest()
    {
    }
    
    private final Set<String>   READ_ONLY_LIBRARIES =
        GSetUtil.newUnmodifiableStringSet(
            "MEjbApp", "__ejb_container_timer_app", "__JWSappclients" );
    
    // see bug#6323557 "admin GUI becomes non-responsive after adding a library"
    private final Set<String>   DONT_TEST_LIBRARIES =
        GSetUtil.newUnmodifiableStringSet( "admingui" );

    private static final String[]   TEST_LIBS   = new String[] { "/foo", "/bar" };
    
    /**
        public void
	testGUIHang()
	{
	    final String[]   TEST_LIBS   = new String[] { "/foo", "/bar" };
	    final ObjectName    objectName  = Util.newObjectName( "amx:j2eeType=X-WebModuleConfig,name=admingui" );
	    final WebModuleConfig   cfg = getProxyFactory().getProxy( objectName );
	    
	    final String[]  saveLibs    = cfg.getLibraries();
	    assert( saveLibs != null );
	    
	    final String[]  testLibs    = ArrayUtil.newArray( saveLibs, TEST_LIBS );
	    try
	    {
		    cfg.setLibraries( testLibs );
	    }
	    finally
	    {
	        cfg.setLibraries( saveLibs );
	    }
	}
	*/
	
		public void
	testLibraries()
	{
		final Set<Libraries>	all = getTestUtil().getAllAMX( Libraries.class );
		
		for( final Libraries l : all )
		{
		    final AMX   amx = (AMX)l;
		    
		    if ( DONT_TEST_LIBRARIES.contains( amx.getName() ) )
		    {
		        continue;
		    }
		    
		    final ObjectName    objectName  = Util.getObjectName( amx );

		    final String[]  saveLibs    = l.getLibraries();
		    assert( saveLibs != null );
		    
		    final String[]  testLibs    = ArrayUtil.newArray( saveLibs, TEST_LIBS );
		    try
		    {
    		    l.setLibraries( testLibs );
		    }
		    catch( Exception e )
		    {
		        if ( ! READ_ONLY_LIBRARIES.contains( ((AMX)l).getName() ) )
		        {
		        warning ("Couldn't change Libraries Attribute for " + objectName +
		            " (probably read-only, though not advertised as such)" );
		        }
		    }
		    finally
		    {
		        l.setLibraries( saveLibs );
		    }
		    
		}
	}
 
}


