/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/config/ModuleMonitoringLevelsConfigTest.java,v 1.6 2006/03/09 20:30:55 llc Exp $
 * $Revision: 1.6 $
 * $Date: 2006/03/09 20:30:55 $
 */
package com.sun.enterprise.management.config;

import java.util.Map;
import java.util.HashMap;

import javax.management.ObjectName;


import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

import com.sun.appserv.management.config.ModuleMonitoringLevelsConfig;
import com.sun.appserv.management.config.MonitoringServiceConfig;


/**
 */
public final class ModuleMonitoringLevelsConfigTest extends AMXTestBase
{
		public
	ModuleMonitoringLevelsConfigTest ()
	{
	}
	
		public void
	testGetAll()
	{
		final ModuleMonitoringLevelsConfig	config	= getModuleMonitoringLevelsConfig();
		
		final Map<String,String>	all	= config.getAllLevels();
		assert( all.size() == 11 );
	}
	
	
		public void
	testCreateRemove()
	{
	    ModuleMonitoringLevelsConfig    existing    = getModuleMonitoringLevelsConfig();
	    
	    final MonitoringServiceConfig mon = getConfigConfig().getMonitoringServiceConfig();
	    mon.removeModuleMonitoringLevelsConfig();
	    final ModuleMonitoringLevelsConfig  newMM   =
	        mon.createModuleMonitoringLevelsConfig( null );
	    
	    newMM.changeAll( "HIGH" );
	}
}


