/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeanapi-impl/tests/com/sun/enterprise/management/ext/wsmgmt/WebServiceConfigCRTest.java,v 1.3 2006/03/09 20:30:57 llc Exp $
 * $Revision: 1.3 $
 * $Date: 2006/03/09 20:30:57 $
 */
package com.sun.enterprise.management.ext.wsmgmt;

import java.util.Set;
import java.util.Iterator;
import java.io.IOException;
import java.util.Map;
import java.util.HashMap;


import javax.management.ObjectName;
import javax.management.AttributeList;
import javax.management.MBeanServerConnection;
import javax.management.NotCompliantMBeanException;

import com.sun.appserv.management.j2ee.J2EEDomain;


import com.sun.appserv.management.util.jmx.MBeanServerConnectionConnectionSource;

import com.sun.enterprise.management.support.AMXNonConfigImplBase;
import com.sun.enterprise.management.support.QueryMgrImpl;
import com.sun.appserv.management.ext.wsmgmt.WebServiceMgr;
import com.sun.appserv.management.util.misc.ExceptionUtil;

import com.sun.appserv.management.config.WebServiceEndpointConfig;
import com.sun.appserv.management.config.TransformationRuleConfig;
import com.sun.appserv.management.config.J2EEApplicationConfig;
import com.sun.appserv.management.base.XTypes;
import com.sun.appserv.management.base.Util;

import com.sun.enterprise.management.AMXTestBase;
import com.sun.enterprise.management.Capabilities;

/**
 */
public final class WebServiceConfigCRTest extends AMXTestBase
{

    public  WebServiceConfigCRTest() throws IOException {
    }
    
	    public static Capabilities
	getCapabilities()
	{
	    return getOfflineCapableCapabilities( false );
	}
	
    public void testConfigCR() {
        assert (getDomainRoot().getWebServiceMgr() != null);

       final Set<J2EEApplicationConfig>   s   =
        getDomainRoot().getQueryMgr().queryJ2EETypeSet( XTypes.J2EE_APPLICATION_CONFIG);

       final Iterator iter = s.iterator();
       while ( iter.hasNext() )
       {

            J2EEApplicationConfig ac  = (J2EEApplicationConfig)iter.next();
            System.out.println("config name is " + ac.getName());
                            
            Map m = ac.getWebServiceEndpointConfigMap();             
            int init  = m.size();
            System.out.println("WebServiceEndpoints found " + init);
            Iterator itr = m.values().iterator();
            while (itr.hasNext()) {
                WebServiceEndpointConfig wsCfg = (WebServiceEndpointConfig)
                itr.next();
                System.out.println("WebServiceEndpoint's name " + 
                        wsCfg.getName());
            }

            /*
             if ( !( ac.getName().equals("jaxrpc-simple") ) ){
                continue;
             }

            ac.createWebServiceEndpointConfig("remove#me", null);

            m = ac.getWebServiceEndpointConfigMap();             
            int afterCreate  = m.size();
            System.out.println("WebServiceEndpoints found " + afterCreate);

            assert ( init +1== afterCreate);
            */
       }
       assert(true);
    }    

    public void testWSConfigCR() {
        assert (getDomainRoot().getWebServiceMgr() != null);

       final Set<WebServiceEndpointConfig>   s   =
        getDomainRoot().getQueryMgr().queryJ2EETypeSet(
                              XTypes.WEB_SERVICE_ENDPOINT_CONFIG);

       for( final WebServiceEndpointConfig wsc : s )
       {
            Map m = wsc.getTransformationRuleConfigMap();
            int init = m.size();
            System.out.println("Transformation rules found " + init);
            Iterator itr = m.values().iterator();
            while (itr.hasNext()) {
                TransformationRuleConfig trCfg = (TransformationRuleConfig)
                itr.next();
                System.out.println("Transformation Rule's name "+ 
                        trCfg.getName());
            }

            /*

            /* Finish later, creating a transformation rule requires the
             * transformation file to be uploaded to DAS.

            wsc.createTransformationRuleConfig("xrule22",
                "/tmp/req.xsl", false, "request", null);

            m = wsc.getTransformationRuleConfigMap();
            int afterCreate  = m.size();
            System.out.println("Transformation rules found " + afterCreate);

            assert ( init +1== afterCreate);

            wsc.removeTransformationRuleConfig("xrule22");
            m = wsc.getTransformationRuleConfigMap();
            int afterDel  = m.size();
            System.out.println("Transformation rules found " + afterDel);

            assert ( init == afterDel);
            */
       }
       assert(true);
    }

}


