/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/valueaccessor/PrefixedValueAccessorBase.java,v 1.3 2005/12/25 03:42:06 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:06 $
 */
package com.sun.enterprise.admin.dottedname.valueaccessor;


import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;
import javax.management.MBeanServerConnection;
import javax.management.ReflectionException;
import javax.management.MBeanException;
import javax.management.InstanceNotFoundException;
import javax.management.AttributeNotFoundException;
import javax.management.RuntimeOperationsException;
import javax.management.JMException;

import javax.management.MBeanServerConnection;

public abstract class PrefixedValueAccessorBase extends ValueAccessorBase
{
    String _prefix = null; //should be overriden by children
    
    public PrefixedValueAccessorBase(MBeanServerConnection conn, String prefix)
	{
		super( conn );
        _prefix = prefix;
	}
    String getDottedNamePrefix()
    {
        
        if(_prefix==null)
            throw new RuntimeException("Prefix is not set by children class");
        return _prefix;
    }

    String extractPrefixedValueName(String dottedName)
    {
        return extractPrefixedValueName(dottedName, false);
    }
    
    String extractPrefixedValueName(String dottedName, boolean bIncludingPrefix)
    {
        int lastIdx = dottedName.lastIndexOf("."+getDottedNamePrefix());
        lastIdx++;
        if(lastIdx<1)
        {
            if(dottedName.startsWith(getDottedNamePrefix()))
                lastIdx = 0;
            else
                return null;
        }
        if(bIncludingPrefix)
            return dottedName.substring(lastIdx);
        else
            return dottedName.substring(lastIdx+getDottedNamePrefix().length());
    }
    
    boolean isDottedNameForAccessor(String dottedName)
    {
        return (extractPrefixedValueName(dottedName)!=null);
    }
}


