/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/valueaccessor/ValueAccessor.java,v 1.3 2005/12/25 03:42:08 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:08 $
 */
 

package com.sun.enterprise.admin.dottedname.valueaccessor;

import javax.management.Attribute;
import javax.management.ObjectName;


/*
	Implementors of this interface are responsible for getting and setting values,
	however that may happen.  The need for this is driven by the fact that values
	can be accessed as attributes or operations (with varying names).
	
	This particular interface is designed for use with the CLI, so get/set require
	the use of 'String', though the implementing class may choose to coerce the
	String to another data type.
 */
public interface ValueAccessor
{
	/*
		Get a value by name.  Throw an exception if it cannot be found.
	 */
	public Attribute		getValue( ObjectName objectName,  String valueName ) throws Exception;
	
	/*
		Set a value by name.  An exception should be thrown if a failure occurs.
		
		The return Attribute may be different than the original.
	 */
	public Attribute		setValue( ObjectName objectName, Attribute attr ) throws Exception;
}



