/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/dottedname/valueaccessor/ValueAccessorBase.java,v 1.3 2005/12/25 03:42:08 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:08 $
 */
 

package com.sun.enterprise.admin.dottedname.valueaccessor;

import java.lang.reflect.Array;

import javax.management.MBeanServerConnection;
import javax.management.IntrospectionException;
import javax.management.ReflectionException;
import javax.management.InstanceNotFoundException;
import javax.management.AttributeList;
import javax.management.MBeanInfo;
import javax.management.MBeanAttributeInfo;
import javax.management.ObjectName;
import javax.management.Attribute;

import com.sun.enterprise.admin.util.ClassUtil;
import com.sun.enterprise.admin.util.Tokenizer;
import com.sun.enterprise.admin.util.TokenizerImpl;


abstract class ValueAccessorBase implements ValueAccessor
{
	final MBeanServerConnection		mConn;
	
	
		MBeanServerConnection
	getMBS()
	{
		return( mConn );
	}

		public
	ValueAccessorBase( MBeanServerConnection conn )
	{
		mConn	= conn;
	}
	
	final char	ARRAY_ELEMENT_SEPARATOR	= ',';
	final char	ESCAPE_CHAR				= '\\';
	
		String []
	stringToStringArray( final String s )
		throws com.sun.enterprise.admin.util.TokenizerException
	{
		final String	delimiters		= "" + ARRAY_ELEMENT_SEPARATOR;
		final String	escapableChars	= "" + ARRAY_ELEMENT_SEPARATOR + ESCAPE_CHAR;
		
		final Tokenizer	tok	= new TokenizerImpl( s, delimiters, false, ESCAPE_CHAR, escapableChars );
		
		final String []	values	= tok.getTokens();
		
		return( values );
	}
	
		Object []
	convert( final String [] stringValues, final Class elementClass )
		throws Exception
	{
		if ( elementClass == String.class )
		{
			return( stringValues );
		}
		
		if ( ClassUtil.classnameIsPrimitiveArray( elementClass.getName() ) )
		{
			throw new IllegalArgumentException(  );
		}
		
		final Object []	values	= (Object [])Array.newInstance( elementClass, stringValues.length );
		
		for( int i = 0; i < values.length; ++i )
		{
			values[ i ]	= ClassUtil.InstantiateFromString( elementClass, stringValues[ i ] );
		}
		
		return( values );
	}
	
		Object []
	stringToArray( final String s, final Class elementClass )
		throws Exception
	{
		final String []	stringValues	= stringToStringArray( s );
		
		final Object []	values	= convert( stringValues, elementClass );
		
		return( values );
	}
	
		
		Object
	coerceToClass( final Class theClass, String value )
		throws Exception
	{
		Object	result	= value;
		
		if ( theClass != String.class )
		{
			if ( ClassUtil.classIsArray( theClass ) )
			{
				final String	theClassName		= theClass.getName();
				final String	elementClassName	= ClassUtil.getArrayMemberClassName( theClassName );
				
				// convert the string to an array of strings
				result	= stringToArray( value, ClassUtil.getClassFromName( elementClassName ) );
			}
			else
			{
				boolean 	canCoerce	= true;
				
				final Class resultClass	= ClassUtil.PrimitiveClassToObjectClass( theClass );
				
				if ( resultClass == Boolean.class  )
				{
					// insist on "true" or "false" (case insensitive)
					canCoerce	= value.equalsIgnoreCase( "true" ) || value.equalsIgnoreCase( "false" );
				}
				
				if ( canCoerce )
				{
					result	= ClassUtil.InstantiateFromString( resultClass, value );
				}
			}
		}
		return( result );
	}

	public abstract Attribute	getValue( ObjectName objectName, String valueName ) throws Exception;
	public abstract Attribute	setValue( ObjectName objectName, Attribute attr ) throws Exception;
}






