/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.mbeanapi;

import java.util.Properties;

import javax.management.MBeanException;
import javax.management.ObjectName;

import com.sun.enterprise.admin.common.exception.DeploymentException;
import com.sun.enterprise.admin.common.exception.ServerInstanceException;
import com.sun.enterprise.admin.common.exception.MBeanConfigException;
import com.sun.enterprise.deployment.backend.DeploymentStatus;

public interface IApplicationsConfigMBean {
    
    public DeploymentStatus deploy(Properties props)
        throws MBeanException, DeploymentException;
   
    public DeploymentStatus undeploy(Properties props)
        throws MBeanException, DeploymentException;

    public boolean deployJ2EEApplication(Properties props)
        throws MBeanException, DeploymentException;
    
    public boolean deployEJBJarModule(Properties props) 
        throws MBeanException, DeploymentException; 
      
    public boolean deployWarModule(Properties props)
        throws MBeanException, DeploymentException;
                
    public boolean deployConnectorModule(Properties props)
        throws MBeanException, DeploymentException;
    
    public String[] getTargets() 
        throws MBeanException, MBeanConfigException;

    public String[] getAvailableModules(String moduleType) 
        throws MBeanException, MBeanConfigException;
    
    public String[] getAvailableModules(String moduleType, String[] targetList)
        throws MBeanException, MBeanConfigException;
    
    public String[] getRunningModules(String moduleType, String[] targetList)
        throws MBeanException, MBeanConfigException;
    
    public String[] getNonRunningModules(String moduleType, String[] targetList)
        throws MBeanException, MBeanConfigException;
    
    public String[] getDeployedJ2EEApplications() 
        throws MBeanException, ServerInstanceException;
      
    public String[] getDeployedEJBModules() 
        throws MBeanException, ServerInstanceException;

    public String[] getDeployedWebModules() 
        throws MBeanException, ServerInstanceException;
    
    public String[] getDeployedConnectors() 
        throws MBeanException, ServerInstanceException;
    
    public ObjectName[] getAllDeployedComponents() 
        throws MBeanException, ServerInstanceException;

    public ObjectName[] getAllDeployedJ2EEApplications() 
        throws MBeanException, ServerInstanceException;
    
    public ObjectName[] getAllDeployedEJBModules() 
        throws MBeanException, ServerInstanceException;
    
    public ObjectName[] getAllDeployedWebModules() 
        throws MBeanException, ServerInstanceException;
    
    
    public ObjectName[] getAllDeployedConnectors() 
        throws MBeanException, ServerInstanceException;
    
    public ObjectName[] getAllDeployedComponents(String target) 
        throws MBeanException, ServerInstanceException;
    
    public ObjectName[] getAllDeployedJ2EEApplications(String target) 
        throws MBeanException, ServerInstanceException;


    public ObjectName[] getAllDeployedEJBModules(String target) 
        throws MBeanException, ServerInstanceException;
 
    public ObjectName[] getAllDeployedWebModules(String target) 
        throws MBeanException, ServerInstanceException;
 
    public ObjectName[] getAllDeployedConnectors(String target) 
        throws MBeanException, ServerInstanceException;
    

    public ObjectName[] getAllDeployedAppclientModules(String target)
        throws MBeanException, ServerInstanceException;
    
    public void associate(String appName, String target)
        throws MBeanException, MBeanConfigException;
    
    public void disassociate(String appName, String target)
        throws MBeanException, MBeanConfigException;
    
    public void enable(String appName, String type, String target)
        throws MBeanException, MBeanConfigException;

    public void disable(String appName, String type, String target)
        throws MBeanException, MBeanConfigException;
    
    public boolean getStatus(String name, String target)
        throws MBeanException, MBeanConfigException;
    
    public boolean isRedeploySupported()
        throws MBeanException, MBeanConfigException;   
    
  
    public String[] getAvailableVersions(String appName, String type) 
        throws MBeanException, MBeanConfigException;
        
    public String getDefaultVersion(String appName, String type) 
        throws MBeanException, MBeanConfigException;
        
    public String getLastModified(String appName, String type) 
        throws MBeanException, MBeanConfigException;    
    
    public boolean isRepositoryCleanerEnabled() 
        throws MBeanException, MBeanConfigException;
    

    public int getRepositoryCleanerPollingInterval() 
        throws MBeanException, MBeanConfigException;
    
    public void setRepositoryCleanerPollingInterval(int interval)
        throws MBeanException, MBeanConfigException;
    
    public int getMaxApplicationVersions() 
        throws MBeanException, MBeanConfigException;
        
    public void setMaxApplicationVersions(int maxVersions)
        throws MBeanException, MBeanConfigException;
        
    public boolean isAutoDeployEnabled() 
        throws MBeanException, MBeanConfigException;
    
    public void setAutoDeployEnabled() 
        throws MBeanException, MBeanConfigException;

    public boolean isAutoDeployJspPreCompilationEnabled()
        throws MBeanException, MBeanConfigException;
    
    public void setAutoDeployJspPreCompilationEnabled()
        throws MBeanException, MBeanConfigException;
    
    public String[] getModuleComponents(String standAloneModuleName)
        throws MBeanException, ServerInstanceException;

    public String[] getModuleComponents(String appName, String modName) 
        throws MBeanException, ServerInstanceException;

    public String[] getAllSystemConnectors() 
        throws MBeanException, ServerInstanceException;    
}
