/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.mbeans;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipFile;
/**
 * @author Sreenivas Munnangi
 */

public interface DomainDiagnosticsMBean {

    /**
     * Generates Diagnostic Report
     * Following are the keys expected in the input  
     * logstartdate = log start date : Date in MM/DD/YY format from which
     * server.log is collected.
     * logenddate = log end date : Date in MM/DD/YY format to which
     * server.log is collected.
     * bugids = bugids : list of bug ids separataed by comma
     * target = target could be a domain, a cluster, a node agent or a instance
     * input = Input specified by the user in admin GUI : String
     * @param input input specified by the user
     * @return zip containing diagnostic report
     * @throw DiagnosticException 
     */
    public String generateReport(Map input) throws  Exception ;
    
    /**
     * @return list of attributes being masked with ****
     * @throw DiagnosticException 
     */
    public List<String> getConfidentialProperties() throws  Exception;
    
}
