/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 
/*
 * $Header: /cvs/glassfish/admin/mbeans/src/java/com/sun/enterprise/admin/mbeans/DottedNameMBeansIniter.java,v 1.3 2005/12/25 03:42:19 tcfujii Exp $
 * $Revision: 1.3 $
 * $Date: 2005/12/25 03:42:19 $
 */
package com.sun.enterprise.admin.mbeans;
 

import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ObjectInstance;

import com.sun.enterprise.admin.common.ObjectNames;
import com.sun.enterprise.admin.util.ClassUtil;

import com.sun.enterprise.admin.dottedname.DottedNameRegistry;
import com.sun.enterprise.admin.dottedname.DottedNameGetSetMBean;
import com.sun.enterprise.admin.server.core.AdminService;
import com.sun.enterprise.admin.AdminContext;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

/*
	A registry for DottedName-to-ObjectName mapping.
 */
public class DottedNameMBeansIniter
{
		public
	DottedNameMBeansIniter( MBeanServer server )
		throws Exception
	{
		init( server );
	}
	
	
		public void
	init( MBeanServer server )
		throws Exception
	{
		// config registry
		final DottedNameRegistry registry	= new DottedNameRegistryMBeanImpl();
		server.registerMBean( registry, ObjectNames.getDottedNameRegistryObjectName() );
		
		// monitoring registry
		final DottedNameRegistry monitoringRegistry	= new DottedNameRegistryMBeanImpl();
		server.registerMBean( monitoringRegistry, ObjectNames.getDottedNameMonitoringRegistryObjectName() );
		
		
		/*	dotted name get-set
			probably would be cleaner to generate proxies for registry & monitoringRegistry, but
			that would only matter if these objects were unregistered an re-registered (unlikely).
			
			It is also more efficient to just call them directly.
		 */
		server.registerMBean(
                getDottedNameGetSetMBean(server, registry, monitoringRegistry),
			    ObjectNames.getDottedNameGetSetObjectName() );
	}

    private DottedNameGetSetMBean getDottedNameGetSetMBean(
                                    final MBeanServer server,
                                    final DottedNameRegistry registry,
                                    final DottedNameRegistry monitoringRegistry)
                                    throws Exception
    {
        final String dnClassName= AdminService.getAdminService().getAdminContext().getDottedNameMBeanImplClassName();
        final Class dnClass = Class.forName(dnClassName);
        final Class[] types = new Class[]{javax.management.MBeanServerConnection.class,
                                          com.sun.enterprise.admin.dottedname.DottedNameRegistry.class,
                                          com.sun.enterprise.admin.dottedname.DottedNameRegistry.class};
        final Constructor dnConstructor = dnClass.getConstructor(types);
        final Object[] params = new Object[]{server, registry, monitoringRegistry}; 
        final DottedNameGetSetMBean dnMbean = (DottedNameGetSetMBean) dnConstructor.newInstance(params);
        return dnMbean;
    }
}

