/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: JmxConnectorMBean.java,v 1.2 2006/03/18 00:34:36 kravtch Exp $
 */

package com.sun.enterprise.admin.mbeans;

//JMX imports
import javax.management.AttributeNotFoundException;
import javax.management.ReflectionException;
import javax.management.MBeanException;

import com.sun.enterprise.admin.jmx.remote.server.rmi.JmxServiceUrlFactory;
import javax.management.remote.JMXServiceURL;

// commons imports
import com.sun.enterprise.util.i18n.StringManager;

//admin/config imports
import com.sun.enterprise.admin.config.BaseConfigMBean;
import com.sun.enterprise.admin.config.MBeanConfigException;

//config imports
import com.sun.enterprise.config.serverbeans.JmxConnector;
import com.sun.enterprise.config.ConfigException;

// java.net
import java.net.InetAddress;
import java.net.UnknownHostException;

public class JmxConnectorMBean extends BaseConfigMBean
{
    final private static String HOST_HOLDER_VALUE = "<host-name>";
    final private static int PORT_HOLDER_VALUE = 12345;

    private static final StringManager localStrings =
            StringManager.getManager(DomainMBean.class);
    
    private String getJMXServiceURL()
       throws UnknownHostException
    {
        
        //first create template
        JMXServiceURL url = 
        JmxServiceUrlFactory.forJconsoleOverRmiWithJndiInAppserver(
                HOST_HOLDER_VALUE, PORT_HOLDER_VALUE);
        String strUrl  = url.toString();
        //now - modify it
        JmxConnector bean = (JmxConnector)this.getBaseConfigBean();
        String host = bean.getAddress();
        if(host!=null && host.trim().equals("0.0.0.0"))
        {
           //host = InetAddress.getLocalHost().getHostName();    
           host = null; //left <host-name> placeholder in url
        }
        if(host!=null)
            strUrl = strUrl.replaceAll(HOST_HOLDER_VALUE, host);
        try {
           int port = Integer.parseInt(bean.getPort());
           strUrl = strUrl.replaceAll(String.valueOf(PORT_HOLDER_VALUE), 
                   String.valueOf(port));
        } catch (Exception e)
        {
           strUrl = strUrl.replaceAll(String.valueOf(PORT_HOLDER_VALUE), 
                   "<port>");
        }
        
        return strUrl;
    }
    
    /** overriding of the super getAttribute() 
     *  to provide "in mbean only" JMXServiceURL attribute
     **/
    public Object getAttribute(String name)
       throws AttributeNotFoundException, MBeanException, ReflectionException {

        if(name.equals(JMX_SERVICE_URL_ATTRNAME))
        {
            try {
                return getJMXServiceURL();
            } catch (UnknownHostException uhe) {
                throw new MBeanException(uhe);
            }
        }
        return super.getAttribute(name);
    }
    
    public static final String JMX_SERVICE_URL_ATTRNAME  = "JMXServiceURL";
}
