/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * JVMInformation.java
 *
 * Created on July 20, 2005, 10:24 PM
 */

package com.sun.enterprise.admin.mbeans.jvm;

import com.sun.enterprise.util.SystemPropertyConstants;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

/**
 */
public class JVMInformation  implements JVMInformationMBean, MBeanRegistration {
    private MBeanServerConnection mbsc = null;
    /** Creates a new instance of JVMInformation */
    public JVMInformation() {
    }

    public String getThreadDump(String processName) {
        final ThreadMonitor tm = new ThreadMonitor(mbsc);
        return ( tm.getThreadDump() );
    }

    public String getSummary(String processName) {
        final SummaryReporter sr = new SummaryReporter(mbsc);
        return ( sr.getSummaryReport() );
    }

    public String getMemoryInformation(String processName) {
        final MemoryReporter mr = new MemoryReporter(mbsc);
        return ( mr.getMemoryReport() );
    }

    public String getClassInformation(String processName) {
        final ClassReporter cr = new ClassReporter(mbsc);
        return ( cr.getClassReport() );
    }

    public void postRegister(Boolean registrationDone) {
    }

    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        this.mbsc = server;
        final String sn = System.getProperty(SystemPropertyConstants.SERVER_NAME);
        final ObjectName on = JVMInformationCollector.formObjectName(sn, JVMInformation.class.getSimpleName());
        return ( on );
    }

    public void preDeregister() throws Exception {
    }

    public void postDeregister() {
    }
    
}
