/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;

import javax.management.ObjectName; 
import com.sun.enterprise.management.util.J2EEModuleCallBack;

public class AppClientModuleMdl extends J2EEModuleMdl {
    private String APPCLIENTMODULE = "AppClientModule";
    
    private String appClientName = null;
    private String applicationName = null;

    public AppClientModuleMdl(J2EEModuleCallBack module) {
        super(module);
        appClientName = module.getName();
        applicationName = module.getParentName();
        if(isStandAloneModule(applicationName))
           this.applicationName = "null";
    }

    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this method and return the appropriate type string.
     */
    public String getj2eeType() {
        return APPCLIENTMODULE;
    }
    
    /** Accessor method for the parent key */
    public String getJ2EEApplication() {
        return this.applicationName;
    }
    
    public String getModuleName() {
        // I am not sure, if I should be returning this.
        return this.appClientName;
    }

    public void addVm(String vmId) {
        super.addVm(vmId);
    }
}
