/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.model;


import java.util.*;
import javax.management.*;
import com.sun.enterprise.management.util.J2EEModuleCallBack;

public class WebModuleMdl extends J2EEModuleMdl {

    private static String MANAGED_OBJECT_TYPE = "WebModule";
    
    private String webModuleName = null;
    private String applicationName = null;
    public WebModuleMdl(J2EEModuleCallBack module) {
	super(module);
        this.webModuleName = module.getName();
        this.applicationName = module.getParentName();
        if(isStandAloneModule(applicationName))
           this.applicationName = "null";
    }

    public String[] getservlets() {
        //Set appMods = findNames("j2eeType=WebModule,name=" + getname()+",J2EEServer=" + getJ2EEServer()+",J2EEApplication="+this.applicationName);
        Set appMods = findNames("j2eeType=Servlet,WebModule=" +this.webModuleName+",J2EEServer=" + getJ2EEServer()+",J2EEApplication="+this.applicationName);
        
        Iterator it = appMods.iterator();
        String [] mods = new String[appMods.size()];
        int i =0;
        while(it.hasNext()) {
            mods[i++] = ((ObjectName)it.next()).toString();
        }
        return mods;
    }
    
    /**
     * The type of the J2EEManagedObject as specified by JSR77. The class that implements a specific type must override this method and return the appropriate type string.
     */
    public String getj2eeType() {
        return MANAGED_OBJECT_TYPE;
    }
    
    /** Accessor method for the parent key */
    public String getJ2EEApplication() {
        return this.applicationName;
    }
    
    public String getModuleName() {
        return this.webModuleName;
    }
    
}
