/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: ResourcesMBeanTest.java,v 1.3 2005/12/25 03:43:13 tcfujii Exp $
 */

package com.sun.enterprise.admin.mbeans;

import com.sun.enterprise.admin.jmx.remote.DefaultConfiguration;
import com.sun.enterprise.admin.target.TargetType;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigFactory;
import com.sun.enterprise.deployment.backend.DeploymentStatus;
import com.sun.enterprise.deployment.util.DeploymentProperties;
//jdk imports
import java.util.Properties;
import java.io.File;
import java.util.Map;

//junit imports
import junit.framework.*;
import junit.textui.TestRunner;

//JMX imports
import javax.management.AttributeList;
import javax.management.Attribute;
import javax.management.ObjectName;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;


public class ResourcesMBeanTest extends TestCase {
    
    private JMXConnector connector;
    
    private final static String HOST = "localhost";
    private final static String PORT = "4848";
    private final static String ADMIN_USER = "admin";
    private final static String ADMIN_PASSWORD = "adminadmin";
    private final static String APPLICATION = "/export/stateless-simple.ear";
    
    public ResourcesMBeanTest(String name) throws Exception {
        super(name);
    }
    
    /**
     *
     */
    public void testCreateResource() {
        System.out.println("..testCreateResource");
        executeCreateResource("null","dummy", new java.util.HashMap());
        executeCreateResource("","dummy1",new java.util.HashMap());
        executeCreateResource(null,"dummy2",new java.util.HashMap());
    }
    
    /**
     *
     */
    public void testDeleteResource() {
        System.out.println("..testDeleteResource");
        executeDeleteResource("null","dummy");
        executeDeleteResource(null,"dummy1");
        executeDeleteResource("","dummy2");
    }
    
    public void executeCreateResource(String target, String resourceName, Map options) {
        try {
             final MBeanServerConnection server = getMBeanServer();
             String methodToInvoke = "createJdbcConnectionPool";
             Attribute attr1 = new Attribute("datasource_classname","com.pointbase.xa.xaDataSource");
             Attribute attr2 = new Attribute("name",resourceName);
             AttributeList list = new AttributeList();
             list.add(attr1);
             list.add(attr2);
             ObjectName objectName = 
                    new ObjectName(
                        "com.sun.appserv:type=resources,category=config");       
             printMBeanTestInfo(objectName);
             ObjectName result = (ObjectName)server.invoke(objectName,  
                methodToInvoke, new Object[]{list,new Properties(),target},
                new String[]{"javax.management.AttributeList", "java.util.Properties","java.lang.String"});
        } catch(Throwable e) {
            fail(e.getMessage());
        }
    }
    
    public void executeDeleteResource(String target, String resourceName) {
        try {
             final MBeanServerConnection server = getMBeanServer();
             String methodToInvoke = "deleteJdbcConnectionPool";
             ObjectName objectName = 
                    new ObjectName(
                        "com.sun.appserv:type=resources,category=config");       
             printMBeanTestInfo(objectName);
             ObjectName result = (ObjectName)server.invoke(objectName,  
                methodToInvoke, new Object[]{resourceName,target},
                new String[]{"java.lang.String","java.lang.String"});
        } catch(Throwable e) {
            System.out.println("Something failed in deleting the resource!");
            e.printStackTrace();
        }
    }
    
    /**
     *
     */
    public java.util.Properties getDeploymentProperties() {
        java.util.Properties props = new java.util.Properties();
        props.setProperty(DeploymentProperties.ARCHIVE_NAME, APPLICATION);
        props.setProperty(DeploymentProperties.VERIFY, "false");
        props.setProperty(DeploymentProperties.PRECOMPILE_JSP, "false");
        props.setProperty(DeploymentProperties.ENABLE, "true");
        props.setProperty(DeploymentProperties.FORCE, "true");
        return props;
    }
    
    /**
     *
     */
    private void printMBeanTestInfo(ObjectName objectName) {
        System.out.println("Testing mbean invocation on <" + objectName + ">");
    }
    
    /**
     *
     */
    private ObjectName getSampleObjectName() {
        ObjectName name = null;
        try {
            name = 
                new ObjectName("com.sun.appserv:type=jdbc-connection-pool," + 
                    "name=__TimerPool,category=config");
        } catch(Exception e) {
            e.printStackTrace();
        }
        return name;
    }
    
    /**
     *
     */
    private MBeanServerConnection getMBeanServer() {
        MBeanServerConnection conn = null;
        try {
            conn = connector.getMBeanServerConnection();
        } catch(Exception e) {
            System.out.println("Could not retrieve connection! " 
                + e.getMessage());
            e.printStackTrace();
        }
        return conn;
    }
    
    /**
     *
     *
     */
    private void initConnector() {
        try {
            connector = JMXConnectorFactory.connect(
                new JMXServiceURL("service:jmx:s1ashttp://" + HOST + 
                    ":" + PORT), initConnectorEnvironment());
        } catch (Exception ex) {
            System.out.println("Remote Connect Failed!!!");
            System.out.println(ex.getMessage());
            throw new RuntimeException(ex);
        }
    }
    
    /**
     *
     */
    private java.util.Map initConnectorEnvironment() {
        final java.util.Map env = new java.util.HashMap();
        final String PKGS = "com.sun.enterprise.admin.jmx.remote.protocol";
        env.put(JMXConnectorFactory.PROTOCOL_PROVIDER_PACKAGES, PKGS);
        env.put(DefaultConfiguration.ADMIN_USER_ENV_PROPERTY_NAME, ADMIN_USER);
        env.put(DefaultConfiguration.ADMIN_PASSWORD_ENV_PROPERTY_NAME, ADMIN_PASSWORD);
        env.put(DefaultConfiguration.HTTP_AUTH_PROPERTY_NAME,
                DefaultConfiguration.DEFAULT_HTTP_AUTH_SCHEME);
        return (env);
    }
    
    protected void setUp() {
        initConnector();
    }

    protected void tearDown() {
    }

    public static junit.framework.Test suite() {
        TestSuite suite = new TestSuite(ResourcesMBeanTest.class);
        return suite;
    }

    public static void main(String args[]) throws Exception {
        final TestRunner runner= new TestRunner();
        final TestResult result = runner.doRun(ResourcesMBeanTest.suite(), false);
        System.exit(result.errorCount() + result.failureCount());
    }
}