/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * DbAccessObject.java
 *
 * Created on July 11, 2005, 10:38 AM
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.sql.Connection;
import java.util.List;
import java.util.Map;

/**
 *
 * Database Access Object to handle table creates, table deletes and table 
 * updates
 * @author Harpreet Singh
 */
public interface DbAccessObject {
    
   /**
     * Enables the DB Access Object. It acquires connection to the database
     * It creates the required tables in the database. If the tables are present
     * it will not drop them.
     */
    public boolean enable ();

    public boolean disable();

    public boolean clearData();
    
    public boolean insert(TransferObject[] transferObject);
        
    public List<Map<String, String>> getRequestInformation();
    
    public List<Map<String, String>> getCallStackInformation (String requestId);
    
    public Map<String, String> getPieInformation (String requestId);
    
    public boolean deleteRequestIds (String[] requestIds);

}
