/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * StatsDescriptionHelper.java
 *
 * Created on September 17, 2003, 3:12 PM
 */

package com.sun.enterprise.admin.monitor.registry.spi;
import com.sun.enterprise.util.LocalStringManager;
import com.sun.enterprise.util.LocalStringManagerImpl;
/**
 * Provides a localized String that is the Description of a
 * given statistic.
 * @author  Shreedhar Ganapathy<mailto:shreedhar.ganapathy@sun.com>
 */
class StatsDescriptionHelper {
	private LocalStringManager mgr;
	static final String NO_DESCRIPTION_AVAILABLE="No Description was available";
	
	StatsDescriptionHelper(){
		mgr = new LocalStringManagerImpl(this.getClass());
	}
	
	String getDescription(java.lang.String name) {
		return mgr.getLocalString(this.getClass(), name, NO_DESCRIPTION_AVAILABLE);
	}
}
