/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * $Id: StatisticFactory.java,v 1.3 2005/12/25 03:43:45 tcfujii Exp $
 * $Date: 2005/12/25 03:43:45 $
 * $Revision: 1.3 $
 */

package com.sun.enterprise.admin.monitor.stats.spi;
import javax.management.j2ee.statistics.*;
import com.sun.enterprise.admin.monitor.stats.*;

public class StatisticFactory {
    
    /** Creates a new instance of StatisticFactory */
    public StatisticFactory() {
    }
    
    /**
     * returns an instance of the CountStatistic
     * @return  CountStatistic
     */
    public static CountStatistic getCountStatistic(long countVal, String name,
                                                   String unit, String desc,
                                                   long sampleTime, long startTime) {
                                                       
        return new CountStatisticImpl(countVal, name, unit, desc, 
                                      sampleTime, startTime);
    }
    
    /**
     * returns an instance of the RangeStatistic
     * @return  RangeStatistic
     */
    public static RangeStatistic getRangeStatistic(long curVal, long highMark,
                                                   long lowMark, String name,
                                                   String unit, String desc,
                                                   long startTime, long sampleTime) {
        
        return new RangeStatisticImpl(curVal, highMark, lowMark, name, 
                                      unit, desc, startTime, sampleTime);
    }
    
    /**
     * returns an instance of the BoundaryStatistic
     * @return  BoundaryStatistic
     */
    public static BoundaryStatistic getBoundaryStatistic(long lower, long upper,
                                                         String name, String unit,
                                                         String desc, long startTime,
                                                         long sampleTime) {
        
        return new BoundaryStatisticImpl(lower, upper, name, unit, desc, 
                                         startTime, sampleTime);
    }
    
    /**
     * returns an instance of the BoundedRangeStatistic
     * @return  BoundedRangeStatistic
     */
    public static BoundedRangeStatistic getBoundedRangeStatistic(long curVal, long highMark,
                                                                 long lowMark, long upper,
                                                                 long lower, String name,
                                                                 String unit, String desc,
                                                                 long startTime, long sampleTime) {
        
        return new BoundedRangeStatisticImpl(curVal, highMark, lowMark, 
                                             upper, lower, name, unit, 
                                             desc, startTime, sampleTime);
    }
    
    /** 
     * returns an instance of the TimeStatistic
     * @return TimeStatistic
     */
    public static TimeStatistic getTimeStatistic(long counter, long maxTime,
                                                 long minTime, long totalTime, 
                                                 String name, String unit,
                                                 String desc, long startTime,
                                                 long sampleTime) {
                                                     
        return new TimeStatisticImpl(counter, maxTime, minTime, totalTime, 
                                     name, unit, desc, startTime, sampleTime);
                                     
    }
}
