/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * MethodEndAccessObjectImplTest.java
 * JUnit based test
 *
 * Created on July 14, 2005, 11:53 AM
 */

package com.sun.enterprise.admin.monitor.callflow;

import java.sql.DriverManager;
import java.sql.PreparedStatement;
import junit.framework.*;
import java.sql.Connection;
import com.sun.enterprise.admin.monitor.callflow.TableInfo;
import com.sun.enterprise.admin.monitor.callflow.AbstractTableAccessObject;
import org.omg.CORBA.MARSHAL;

/**
 *
 * @author Harpreet Singh
 */
public class MethodEndAccessObjectImplTest extends TestCase {
    Connection con = null;
    TableAccessObject me = null;
    PreparedStatement pstmt = null;
    MethodEndTO[] methodEnd = new MethodEndTO[10];    
    
    public MethodEndAccessObjectImplTest(String testName) {
        super(testName);
    }

    protected void setUp() throws Exception {
      try{
            // TODO code application logic here
            String url="jdbc:derby://localhost:1527/sun-callflow;retrieveMessagesFromServerOnGetMessage=true;create=true;";            
            Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
            con = DriverManager.getConnection(url, "APP", "APP");         
            // drop request start table
            me = MethodEndAccessObjectImpl.getInstance();            
        } catch (Exception e){
            e.printStackTrace();
        }        
        
    }

    protected void tearDown() throws Exception {
        try{
            con.close();
        } finally{
            con = null;
        }
    }


    /**
     * Test of createTable method, of class com.sun.enterprise.admin.monitor.callflow.MethodEndAccessObjectImpl.
     */
    public void testCreateTable() {
        System.out.println("Method End : testCreateTable");
        boolean result = false;
        try{
            result = me.createTable(con);
            System.out.println("Method End Create Table returned = "+ result);
        }catch (Exception e){
            e.printStackTrace();
        }
        assertTrue(result);        
    }
   
    public void testInsert (){
        System.out.println(" testStoremethodEnd");
        try{
            String insertSQL = me.getInsertSQL();
            System.out.println (" Insert SQL :"+ insertSQL);            
            pstmt = con.prepareStatement(insertSQL);            
            
            for (int i = 0; i < methodEnd.length; i++) {
                methodEnd[i] = new MethodEndTO();
                methodEnd[i].requestId = "RequestID_"+i;
                methodEnd[i].timeStamp = System.nanoTime();
                methodEnd[i].exception = null;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        boolean result = me.insert (pstmt, methodEnd);
        System.out.println("testStoremethodEnd returned = "+result);
        assertTrue (result);
    }    
    /**
     * Test of dropTable method, of class com.sun.enterprise.admin.monitor.callflow.MethodEndAccessObjectImpl.
     */
    public void testDropTable() {
        System.out.println("MethodEnd testDropTable");
        boolean result = me.dropTable(con);
        System.out.println("Method End Drop Table returned = "+result);
        assertTrue (result);              
    }

    public static void main(java.lang.String[] argList) {

        
    }
    
}
