/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt.util;

import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.File;

public class DomainXmlSAXParser extends DefaultHandler {
  private final String PROPERTY = "property";
  private int level = 0;
  private String domainXmlEventListenerClass= null;
  private File dtd;

  public String getDomainXmlEventListenerClass() {
	return domainXmlEventListenerClass;
  }

  public void parse(java.io.File domainXml,java.io.File dtd) throws javax.xml.parsers.ParserConfigurationException,org.xml.sax.SAXException,java.io.IOException {
            this.dtd = dtd;
	    SAXParser saxParser; 
	    SAXParserFactory factory = SAXParserFactory.newInstance();
	    saxParser = factory.newSAXParser();
            saxParser.getXMLReader().setEntityResolver((EntityResolver)this);
	    saxParser.parse(domainXml,this);
  }


  public void startElement(String namespaceURI, String localName, String qName, Attributes attrs)
  throws SAXException {
      level++;
      if ( level==2 && PROPERTY.equals(qName)){
          if (attrs != null) {
              for (int i = 0; i < attrs.getLength(); i++) {
                  String aName = attrs.getQName(i); // Attr name
                  String aValue = attrs.getValue(aName);
                  if ("DomainXmlEventListenerClass".equals(aValue)) {
                      domainXmlEventListenerClass=attrs.getValue("value");
                  }
              }
          }
      }
  }


  public void endElement(String namespaceURI, String localName, String qName)
      throws SAXException {
      level--;
  }

  public InputSource resolveEntity(String publicId,String systemId) throws SAXException {
      InputSource is = null;
      try {
          is = new InputSource(new java.io.FileInputStream(dtd));
      } catch(Exception e) {
          throw new SAXException("cannot resolve dtd", e);
      }
      return is;
  }
}


