/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.admin.servermgmt.pe;

import junit.framework.*;
import java.util.HashMap;
import java.util.Map;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import java.util.Properties;
import com.sun.enterprise.admin.servermgmt.InvalidConfigException;
/**
 *
 * @author <a href="mailto:toby.h.ferguson@sun.com">Toby H Ferguson</a>
 * @version $Revision: 1.3 $
 */

public class PEDomainConfigValidatorTest extends TestCase {
  public void testNumPorts(){
	assertEquals(7, dc2.getPorts().size());
  }
  
  public void testDuplicatesInDomainConfig() {
	try {
	  p.uniquePorts(dc2);
	  fail("Expectged an InvalidConfigException indicating that there were duplicate ports");
	}
	catch (InvalidConfigException e){
	  assertEquals("Duplicate ports were found: 1 -> {domain.adminPort, domain.instancePort, http.ssl.port, jms.port}, 2 -> {orb.listener.port, orb.ssl.port}", e.getMessage());
	}
  }
  
  public void testNoDuplicatesInDomainConfig() throws Exception {
	p.uniquePorts(dc1);
  }
  
  public void testNoDuplicatePorts(){
	final Map ports = new HashMap();
	ports.put("a", "1");
	assertEquals("", p.getDuplicatePorts(ports));
  }
  
  public void testGetDuplicatePorts() {
	final Map ports = new HashMap();
	ports.put("a", "1");
	ports.put("b", "1");
	ports.put("c", "2");
	ports.put("d", "2");
	ports.put("e", "3");
	assertEquals("1 -> {a, b}, 2 -> {c, d}", p.getDuplicatePorts(ports));
  }

  public PEDomainConfigValidatorTest(String name){
	super(name);
  }

  PEDomainConfigValidator p;
  DomainConfig dc1, dc2;
  
  protected void setUp() throws Exception {
	p = new PEDomainConfigValidator();
	dc1 = new DomainConfig("domainName",
						  new Integer(1),
						  "domainRoot", 
						  "adminUser",
						  "adminPassword",
						  "masterPassword",
						  new Integer(2),
						  "jmsUser",
						  "jmsPassword",
						  new Integer(3), 
						  new Integer(4),
						  new Integer(5), 
						  new Integer(6),
						  new Integer(7),
						  new Properties()){
		protected String getFilePath(String p){
		  return p;
		}
	  };
	dc2 = new DomainConfig("domainName",
						  new Integer(1),
						  "domainRoot", 
						  "adminUser",
						  "adminPassword",
						  new Integer(1),
						  "jmsUser",
						  "jmsPassword",
						  new Integer(1), 
						  new Integer(2),
						  new Integer(1), 
						  new Integer(2),
						  new Integer(3),
						  new Properties()){
		protected String getFilePath(String p){
		  return p;
		}
	  };
  }
  

  protected void tearDown() {
  }

  private void nyi(){
	fail("Not Yet Implemented");
  }

  public static void main(String args[]){
	if (args.length == 0){
	  junit.textui.TestRunner.run(PEDomainConfigValidatorTest.class);
	} else {
	  junit.textui.TestRunner.run(makeSuite(args));
	}
  }
  private static TestSuite makeSuite(String args[]){
	final TestSuite ts = new TestSuite();
	for (int i = 0; i < args.length; i++){
	  ts.addTest(new PEDomainConfigValidatorTest(args[i]));
	}
	return ts;
  }
	
}
