/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation;

import java.util.Map;
import java.util.HashMap;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.ElementProperty;

/**
 * helper class with convenience util methods
 * for reporting errors
*/

/* Class for attribute type Integer */

public abstract class ReportHelper {
    
    final static String ATTR_ERROR_MSG_PREFIX = "AttrValidationError.";
    final static String ERROR_MSG_PREFIX = "ValidationError.";
    /***********************************************************    
     * reports attribute validation error
     ************************************************************/
    static public void reportAttributeError(ValidationContext valCtx, 
            String msgNameSuffix, String defaultMsg, Object[] values)
    {
        valCtx.result.failed( /*getAttributeNameMsgPrefix(valCtx) + */
               valCtx.smh.getLocalString(ATTR_ERROR_MSG_PREFIX + msgNameSuffix, defaultMsg, values) );
    }

    /***********************************************************    
     * reports validation error
     ************************************************************/
    static public void reportValidationError(ValidationContext valCtx, 
            String msgNameSuffix, String defaultMsg, Object[] values)
    {
        valCtx.result.failed( 
              valCtx.smh.getLocalString(ERROR_MSG_PREFIX + msgNameSuffix, 
              defaultMsg, values) );
    }

    static private String getAttributeNameMsgPrefix(ValidationContext valCtx)
    {
        if(valCtx.attrName==null)
            return "";
        return valCtx.smh.getLocalString("common.AttributeErrorMsgPrefix",
              "Attribute {0}: ", new Object[] {valCtx.attrName});
    }
}
