/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.serverbeans.validation.tests;

import java.util.Locale;

import com.sun.enterprise.config.serverbeans.validation.GenericValidator;
import com.sun.enterprise.config.serverbeans.validation.ValidationDescriptor;
import com.sun.enterprise.config.serverbeans.validation.ValidationContext;
import com.sun.enterprise.config.serverbeans.validation.Result;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Resources;
import com.sun.enterprise.config.serverbeans.validation.tests.StaticTest;
import com.sun.enterprise.config.serverbeans.AuthRealm;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.SecurityService;
import com.sun.enterprise.config.serverbeans.ElementProperty;

import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.ConfigContextEvent;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;

import java.util.logging.Level;

/**
    Custom Test for Auth Realm element which calls the Generic Validation before performing custom tests

    @author Srinivas Krishnan
    @version 2.0
*/

public class AuthRealmTest extends GenericValidator {
    
    static boolean checked = false;
    
    public AuthRealmTest(ValidationDescriptor desc) {
        super(desc);
    } 
    
    public void validate(ValidationContext valCtx) {
        super.validate(valCtx); // Before doing custom validation do basic validation
        
        if(valCtx.isDELETE()) {
            AuthRealm ar = (AuthRealm)valCtx.getTargetBean();
            SecurityService sec = (SecurityService) ar.parent();
            String realmName = ar.getName();
            String defaultRealmName = null;
            try {
                defaultRealmName = sec.getDefaultRealm();
            } catch (Exception ee) {
            }
            if(defaultRealmName != null && defaultRealmName.equals(realmName)) {
                valCtx.result.failed(smh.getLocalString(getClass().getName()+".defaultRealmDelete",
                        "Default auth-realm can not be deleted"));
            }
            
            // atleast one element of auth-realm is required
            AuthRealm[] authRealm = sec.getAuthRealm();
            if(authRealm.length < 2)
                valCtx.result.failed(smh.getLocalString(getClass().getName()+".authRealmOneCantDelete",
                        "At least one auth-realm required, auth-realm can not be deleted"));
            
            
        } else if(valCtx.isADD()) {
            AuthRealm ar = (AuthRealm)valCtx.getTargetBean();
            String className = ar.getClassname();
            if(className.endsWith(".FileRealm")) {
                ElementProperty fileProp = ar.getElementPropertyByName("file");
                if(fileProp==null) {
                    valCtx.result.failed(smh.getLocalString(getClass().getName()+".propNotFounfInFileRealm",
                            "Auth realm can not be added. \"{0}\" property should be provided for FileRealm type.", 
                            new Object[]{"file"}));
                }
                ElementProperty jaasContextProp = ar.getElementPropertyByName("jaas-context");
                if(jaasContextProp==null) {
                    valCtx.result.failed(smh.getLocalString(getClass().getName()+".propNotFounfInFileRealm",
                            "Auth realm can not be added. \"{0}\" property should be provided for FileRealm type.", new Object[]{"jaas-context"}));
                }
            }
        }
    }
}
