/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.config.spi;


/**
 * This SPI mechanism allows getting web services Management configuration. Thi
 * provider can be implemented using any configuration storage mechanism 
 * underneath. 
 */
public class ConfigFactory {

    /**
     * Make ConfigFactory private, only one sigleton object is available.
     */
    private ConfigFactory () {
    }

    /**
     * Returns the ConfigFactory singleton.
     *
     * @return the ConfigFactory instance
     */
    public static ConfigFactory  getConfigFactory() {
        return new ConfigFactory();
    }

    /**
     * Returns the ConfigProvider instance. If 
     * -Dconfig.provider.classname is defined, that class is loaded and
     * returned as the repository provider. If there is an error finding or 
     * loading the class, the default provider class is returned.
     *
     * @return RepositoryProvider implementation
     * @throws IllegalAccessException - if the class or its nullary constructor 
     *                                  is not accessible. 
     *         InstantiationException - if this Class represents an abstract 
     *                                  class,an interface, an array class, a 
     *                                  primitive type, or void; or if the class     *                                  has no nullary constructor; or if the 
     *                                  instantiation fails for some other 
     *                                  reason. 
     *         ClassCastException     - if the provider implementation specified
     *                                  by -D does not implement the com.sun.
     *                                  enterprise.admin.wsmgmt.repository.spi.
     *                                  RepositoryProvider interface.
     *         ClassNotFoundException - if the provider implementation specified     *                                  by -D does could not be found by the 
     *                                  class loader.
     */
    public ConfigProvider getConfigProvider() 
      throws InstantiationException, IllegalAccessException, ClassCastException,
        ClassNotFoundException {
       String implName = System.getProperty(CONFIG_PROVIDER_NAME);
       if ( implName == null ) {
            Class repClass = Class.forName(CONFIG_DEFAULT_PROVIDER);
            Object o = repClass.newInstance();
            return (ConfigProvider)o;
       } else {
            Class repClass = Class.forName(implName);
            Object o = repClass.newInstance();
            return (ConfigProvider)o;
       }
    }

    /** Environment property name to customize Repository Provider */
    public static final String CONFIG_PROVIDER_NAME = 
        "config.provider.classname";

    public static final String CONFIG_DEFAULT_PROVIDER = 
        "com.sun.enterprise.admin.wsmgmt.config.impl.AppServConfigProvider";
}
