/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.filter.impl;

import com.sun.enterprise.admin.wsmgmt.config.spi.Constants;
import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;
import com.sun.enterprise.admin.wsmgmt.stats.spi.StatsProviderManager;
import com.sun.enterprise.admin.wsmgmt.stats.impl.WebServiceEndpointStatsProviderImpl;

import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPFault;
import com.sun.enterprise.admin.wsmgmt.SOAPMessageContext;


/**
 * Filter that can implement or collect web services management information 
 */
public class AggregateStatsFilter implements Filter {

    /**
     * Public Constructor.
     *
     * @param epName    End point name for which stats are collected
     */
    public AggregateStatsFilter() {
    }

    /**
     * Returns the unique name for this filter
     */
    public String getName() {
        return Constants.AGGREGATE_STATS_FILTER;
    }

    /**
     * Invoke the filter.
     */
    public void process(String stage, String endpoint, FilterContext context) {

        WebServiceEndpointStatsProviderImpl impl = (
            WebServiceEndpointStatsProviderImpl) StatsProviderManager.
            getInstance().getEndpointStatsProvider(endpoint);

        if ( stage.equals(Filter.PRE_PROCESS_REQUEST) ) {
            impl.setRequestTimeStamp( System.currentTimeMillis(),null, null, 0);
        } else {
            if ( stage.equals(Filter.POST_PROCESS_RESPONSE) ) {

               SOAPMessageContext smc = context.getMessageContext(); 
               SOAPMessage sm = null;
               SOAPFault fault = null;
               try {
                   if (smc != null)
                       sm = smc.getMessage();
                    if (sm != null) {
                        SOAPBody sb = sm.getSOAPBody();
                        if (sb != null) {
                            fault = sb.getFault();
                        }
                    }
                } catch ( Exception e) {
                    // if body can not be obtained, consider this as failure
                    // (fault) case, however fault information is not available
                    impl.setFault(0,
                    System.currentTimeMillis(), context.getExecutionTime(), null,null, null);
                    return;
                }
 
                if ( fault == null) { 
                    impl.setSuccess(0, System.currentTimeMillis(),
                    context.getExecutionTime());
                } else {
                    impl.setFault(0,
                    System.currentTimeMillis(),context.getExecutionTime(),
                    fault.getFaultCode(), fault.getFaultString(), 
                    fault.getFaultString() );
                }
            } else {
                throw new RuntimeException(" Should not be called for this stage of execution of web service end point " + endpoint);
            }
        }

    }

}
