/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.filter.spi;

import java.util.List;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Iterator;
import java.util.Map;
import java.util.HashMap;

import java.util.logging.Logger;
import java.util.logging.Level;
import com.sun.logging.LogDomains;
import com.sun.enterprise.util.i18n.StringManager;

/**
 * This class routes a web service management funtion to an appropriate 
 * filter.
 */
public class FilterRouter {

    /**
     * Applies filter for an endpoint during a particular stage of its
     * processing.
     */
    public void applyFilters(String stage, FilterContext context) {

        if ( context == null) {
            return;
        }

        String endpoint = context.getFullyQualifiedName();

        FilterRegistry fm = FilterRegistry.getInstance();

        if ( fm.isManaged(endpoint) == false) {
            return;
        }
        
        List filters = fm.getFilters(stage, endpoint); 
        if (filters == null) {
            return;
        }
        ListIterator filterItr = filters.listIterator();
        while ( filterItr.hasNext() ) {
            Filter f = (Filter) filterItr.next();
            try {
                f.process(stage, endpoint, context);
            } catch (Exception e) {
                // log a fine message
                _logger.fine("Filter execution for endpoint " + endpoint + " failed: " + e.getMessage());
            }
        }
    }

    public static synchronized FilterRouter getInstance() {
        if ( fr == null) {
            fr = new FilterRouter();
        }
        return fr;
    }

    private static FilterRouter fr = new FilterRouter();

    private FilterRouter() {}
    private static final Logger _logger = 
        Logger.getLogger(LogDomains.ADMIN_LOGGER);
    private static final StringManager _stringMgr = 
        StringManager.getManager(FilterRouter.class);


}
