/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.msg;

import com.sun.enterprise.admin.wsmgmt.config.spi.Constants;
import com.sun.enterprise.admin.wsmgmt.filter.spi.Filter;
import com.sun.enterprise.admin.wsmgmt.filter.spi.FilterContext;
import com.sun.enterprise.admin.wsmgmt.msg.MessageTraceFactory;
import com.sun.appserv.management.ext.wsmgmt.MessageTrace;

/**
 * Filter that can implement or collect web services management information 
 */
public class MessageFilter implements Filter {

    /**
     * Public Constructor.
     *
     * @param appId   name of the application
     * @param endpoint   end point name for which stats are collected
     * @param h  endpoint handler
     */
    public MessageFilter(String appId, String endpoint, EndpointHandler h) {
        _applicationId = appId;
        _endpointId    = endpoint;
        _handler       = h;
    }

    /**
     * Returns the unique name for this filter
     */
    public String getName() {
        return (NAME_PREFIX + _applicationId + DELIM + _endpointId);
    }

    /**
     * Invoke the filter.
     * 
     * @param  stage   stage of the execution
     * @param  endpoint  name of the endpoint
     * @param  context  filter context 
     */
    public void process(String stage, String endpoint, FilterContext context) {

        MessageTraceFactory mtf = MessageTraceFactory.getInstance();

        // SOAP request
        if ( stage.equals(Filter.PROCESS_REQUEST) ) {

            // delegates to message trace factory for holding 
            mtf.processRequest(context, _applicationId);

        // SOAP response
        } else if ( stage.equals(Filter.PROCESS_RESPONSE) ) {
            mtf.processResponse(context);

        } else if (stage.equals(Filter.POST_PROCESS_RESPONSE) ) {
            MessageTrace mt = mtf.postProcessResponse(context);

            // adds the newly created message trace to the pool
            _handler.addMessage(mt);
        }
    }

    // -- PRIVATE - VARIABLES -------------------------
    private String _applicationId            = null;
    private String _endpointId               = null;
    private EndpointHandler _handler         = null;
    private static final String DELIM        = "#";
    private static final String NAME_PREFIX  = "MSGFILTER_";
}
