/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.repository.impl.cache;

import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Collection;

/**
 * Test class for cache manager object. 
 *
 * @author Nazrul Islam
 * @since  J2SE 5.0
 */
class CacheMgrTest {

    public static void testSave() {
        CacheMgr mgr = CacheMgr.getInstance();
        List ejbModules = new ArrayList();
        List webModules = new ArrayList();

        ejbModules.add("ejb1.jar");
        webModules.add("web1.war");
        mgr.addJ2eeApplication("app1",  ejbModules, webModules);

        List ejbModules2 = new ArrayList();
        List webModules2 = new ArrayList();
        ejbModules2.add("ejb2.jar");
        webModules2.add("web2.war");
        ejbModules2.add("ejb3.jar");
        webModules2.add("web3.war");
        mgr.addJ2eeApplication("app2",  ejbModules2, webModules2);

        mgr.addEjbModule("ejb-module1");
        mgr.addWebModule("web-module1");

        mgr.save();
    }

    public static void testLoad() {
        CacheMgr mgr = CacheMgr.getInstance();

        System.out.println("J2EE APPLICATION:");
        Map apps = mgr.getJ2eeApplications();
        Collection values = apps.values();
        for (Iterator iter=values.iterator(); iter.hasNext();) {
            J2eeApplication app = (J2eeApplication) iter.next();
            System.out.println("\t"+app.getName()+"="+app.getPersistentValue());
        }

        System.out.println("EJB MODULES:");
        Map ejbModules = mgr.getEjbModules();
        Collection ejbValues = ejbModules.values();
        for (Iterator iter=ejbValues.iterator(); iter.hasNext();) {
            String ejbModule = (String) iter.next();
            System.out.println("\t"+ejbModule);
        }

        System.out.println("WEB MODULES:");
        Map webModules = mgr.getWebModules();
        Collection webValues = webModules.values();
        for (Iterator iter=webValues.iterator(); iter.hasNext();) {
            String webModule = (String) iter.next();
            System.out.println("\t"+webModule);
        }
    }

    public static void main(String[] args) {
        testSave();
        testLoad();
    }
}
