/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.stats.spi;

import java.util.HashMap;

/**
 * Manages the providers for each endpoint
 */
public class StatsProviderManager {

    /**
     * Registers the Global Listener.
     */
    public void registerEndpointStatsProvider(String endpoint,
        WebServiceEndpointStatsProvider prov) {

        wsEpStatMap.put(endpoint, prov);
    }

    public void unregisterEndpointStatsProvider(String endpoint) {

        wsEpStatMap.remove(endpoint);
    }

    public WebServiceEndpointStatsProvider getEndpointStatsProvider(String
    endpoint) {
       Object obj = wsEpStatMap.get(endpoint);
       if ( obj != null ) {
            return (WebServiceEndpointStatsProvider) obj;
       }
       else {
        return null;
       }
    }

    /*
    public WebServiceEndpointContentStatsProvider 
        getEndpointContentStatsProvider() {
    }
    */

    public static synchronized StatsProviderManager getInstance() {
        if ( sm == null) {
            sm = new StatsProviderManager();
        }
        return sm;
    }

    private static StatsProviderManager sm = null;

    private StatsProviderManager() { wsEpStatMap = new HashMap(); }

    // PRIVATE VARIABLES

    private HashMap wsEpStatMap;
}
