/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.admin.wsmgmt.transform;

import org.xml.sax.XMLFilter;

/**
 * Filter information. 
 */
public class FilterData {

    /**
     * Public Constructor.
     *
     * @param appId   name of the application
     * @param endpoint   end point name for which stats are collected
     */
    public FilterData(String name, XMLFilter filter) {
        _filter = filter;
        _name = name;
    }

    public void setFilter(XMLFilter filter) {
        _filter = filter;
    }

    /**
     * Returns the unique name for this filter
     */
    public String getName() {
        return _name;
    }

    /**
     * Returns the filter
     */
    public XMLFilter getFilter() {
        return _filter;
    }

    // -- PRIVATE - VARIABLES -------------------------
    XMLFilter _filter = null;
    String _name = null;
}
