/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation;

/**
 * Basic interfaced for annotation processing warnings and errors
 *
 * @author Jerome Dochez
 */
public interface ErrorHandler {
    /**
     * Receive notication of a fine error message
     * @param ape The warning information
     * @throws any exception to stop the annotation processing 
     */ 
    public void fine(AnnotationProcessorException ape) throws
            AnnotationProcessorException;
    
    /**
     * Receive notification of a warning
     * @param ape The warning information
     * @throws any exception to stop the annotation processing 
     */
    public void warning(AnnotationProcessorException ape) throws
            AnnotationProcessorException;
    
    /**
     * Receive notification of an error
     * @param ape The error information
     * @throws amy exception to stop the annotation processing
     */
    public void error(AnnotationProcessorException ape) throws 
            AnnotationProcessorException;
    
}
