/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.impl;

import java.util.Map;
import java.util.HashMap;
import java.lang.annotation.Annotation;

import com.sun.enterprise.deployment.annotation.ResultType;
import com.sun.enterprise.deployment.annotation.HandlerProcessingResult;
import com.sun.enterprise.deployment.annotation.AnnotationHandler;

/**
 *
 * @author dochez
 */
public class HandlerProcessingResultImpl implements HandlerProcessingResult {
    
    Map<Class<? extends Annotation>,ResultType> results;
    ResultType overallResult = ResultType.UNPROCESSED;
    
    /**
     * Creates a new instance of HandlerProcessingResultImpl 
     */
    public HandlerProcessingResultImpl(Map<Class<? extends Annotation>, ResultType> results) {
        this.results = results;
    }
    
    public HandlerProcessingResultImpl() {        
        results = new HashMap<Class<? extends Annotation>, ResultType>();
    }
    
    public static HandlerProcessingResultImpl getDefaultResult(Class<? extends Annotation> annotationType, ResultType result) {
        
        HandlerProcessingResultImpl impl = new HandlerProcessingResultImpl();
        impl.results.put(annotationType, result);
        impl.overallResult = result;
        return impl;                
    }
    
    public Map<Class<? extends Annotation>,ResultType> processedAnnotations() {
        return results;
    }
    
    public void addResult(Class<? extends Annotation> annotationType, ResultType result) {
        if (result.compareTo(overallResult)>0) {
            overallResult = result;
        }
        results.put(annotationType, result);
    }
    
    public void addAll(HandlerProcessingResult result) {
         if (result.getOverallResult().compareTo(overallResult)>0) {
            overallResult = result.getOverallResult();
        }
        results.putAll(result.processedAnnotations());
    }
    
    public ResultType getOverallResult(){
        return overallResult;
    }
  
}
