/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.addon;

import java.io.*;
import java.lang.reflect.*;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.*;
import java.util.*;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * This class
 * iterates over all the jars under install/lib/addons
 * read the manifest file of each jar, if supplied
 * read main-class, instantiated it through reflection
 * call *main* method passing user/password as string array arguments 
 * 
 */
public class AddonInstaller {
    
    /** Creates a new instance of AddonInstaller */
    
    public AddonInstaller() {
        
    }
    
    /**
     * This will install all the addons under installDir/lib/addons
     * @param installDir Installation directory
     * @param instanceRoot Domain instance directory
     */
    public void installAllAddons(String installDir, String instanceRoot){
        
        String addonJar = "";
        //Properties registry = new Properties();
        Registry registry = null;
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            String addonDir = installDir + File.separator + AddonConstants.LIB + File.separator + AddonConstants.ADDONS;
            String domainConfigRoot = instanceRoot + File.separator + AddonConstants.CONFIG;
            //Logger.getAnonymousLogger().log(Level.FINE, "domainConfigRoot==="+domainConfigRoot);
            String domainRegistry = domainConfigRoot + File.separator + AddonConstants.DOMAIN_REGISTRY;
            File registryFile = new File(domainRegistry);
            registry = new Registry();
            registry.load(registryFile);
            File libAddonDirectory = new File(addonDir);
            File[] fileArray = libAddonDirectory.listFiles();
        
            for(int i = 0;i<fileArray.length;i++) {
                addonJar = fileArray[i].getName();
                String jarExtension = "";
                int dotLastIndex = addonJar.lastIndexOf(".");
                String jarNameWithoutExtension = addonJar;
                if(dotLastIndex != -1) {
                    jarExtension = addonJar.substring(dotLastIndex + 1);
                    jarNameWithoutExtension = addonJar.substring(0, dotLastIndex);
                }
                if(jarExtension.equalsIgnoreCase("jar")) {
                    //Logger.getAnonymousLogger().log(Level.INFO, "fileArray[i].getName()="+fileArray[i].getName());
                    //String key = domainName + "." + fileArray[i].getName() + "." + "installed";
                    String key = jarNameWithoutExtension + "." + "enabled";
                    String installed = registry.getProperty(key);
                    if(installed != null && installed.equals("true")) {
                        Logger.getAnonymousLogger().log(Level.FINE, "Addon "+addonJar+" is already installed");
                            continue;
                    }
                    Addon addon = new Addon(fileArray[i]);
                    boolean install = addon.install(installDir,instanceRoot);
                    if(install)
                    registry.setProperty(key, "true");
                    
                }
            }
            registry.store();
           
        }catch(Exception ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, "Error while installing the addon "+addonJar, ex);
        }finally {
            try {
                if(registry != null)
                registry.close();
            }catch(Exception e) {
                
            }
        }
    
    }
    
    
    
    public static void main(String[] args) {
        AddonInstaller installer = new AddonInstaller();
        installer.installAllAddons(args[0], args[1]);
    }
    
}
