/*
 * The contents of this file are subject to the terms
 * of the Common Development and Distribution License
 * (the License).  You may not use this file except in
 * compliance with the License.
 *
 * You can obtain a copy of the license at
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing
 * permissions and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL
 * Header Notice in each file and include the License file
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.
 * If applicable, add the following below the CDDL Header,
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.core;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;

/**
 * Registry of all ServiceEndpoints, provides mapping between EndPointName and
 * ServiceEngineEndpoint.
 * @author Manisha Umbarje
 */
public class EndpointRegistry {
    
    /** Service QName to table of endpoints
     * The key being the service name and value being table of ServiceEngineEndpoints
     */
    private Hashtable endpoints;
    
    private static EndpointRegistry store;
    
    /** Creates a new instance of ServiceEndPointRegistry */
    private EndpointRegistry() {
        endpoints = new Hashtable();
    }
    
    public static EndpointRegistry getInstance() {
        if(store == null)
            store = new EndpointRegistry();
        return store;
    }
    
    
    
    /**
     * Adds a ServiceEndpoint to the store
     */
    public void put(QName service, String endpointName, ServiceEngineEndpoint endpoint) {
        Map map=  (Map)endpoints.get(service);
        if(map == null) {
            map = new Hashtable();
            endpoints.put(service, map);
        }
        map.put(endpointName, endpoint);
        
    }
    
    /**
     *
     */
    public ServiceEngineEndpoint get(QName service, String endpointName) {
        
        Map map=  (Map)endpoints.get(service);
        if(map != null)
        return (ServiceEngineEndpoint)map.get(endpointName);
        else
            return null;
        
    }
    
    /**
     * Removes ServiceEndpoint from the store
     */
    public void delete(QName service, String endpointName) {
        
        Map map=  (Map)endpoints.get(service);
        map.remove(endpointName);
        
    }
    
    public Iterator<ServiceEngineEndpoint> list() {
        return endpoints.values().iterator();
    }
}
