/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.jbi.serviceengine.core;




import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;

/**
 * Bootstrap class for installation purpose
 * @author Manisha Umbarje
 */
public class JavaEEServiceEngineBootstrap 
        implements Bootstrap {

    /**
     * This is the installation context given by the framework.
     */
    private InstallationContext context;

    
    
    /** Creates a new instance of JavaEEServiceEngineBootstrap */
    public JavaEEServiceEngineBootstrap() {
    }

    /**
     * Cleans up any resources allocated by the bootstrap implementation,
     * including deregistration of the extension MBean, if applicable.
     * This method will be called after the onInstall() or onUninstall() method
     * is called, whether it succeeds or fails.
     * @throws javax.jbi.JBIException when cleanup processing fails to complete
     * successfully.
     */
    public void cleanUp() throws JBIException {
    }

    /**
     * Get the JMX ObjectName for the optional installation configuration MBean
     * for this BC. If there is none, the value is null.
     *
     * @return ObjectName the JMX object name of the installation configuration
     *         MBean or null if there is no MBean.
     */
    public javax.management.ObjectName getExtensionMBeanName(){
        return null;
    }

    /**
     * Called to initialize the BC bootstrap.
     *
     * @param installContext is the context containing information from the
     *        install command and from the BC jar JavaEEServiceEngine.
     *
     * @throws javax.jbi.JBIException when there is an error requiring that the
     *         installation be terminated.
     */
    public void init(InstallationContext installContext)
        throws JBIException {
        context = installContext;
    }

    /**
     * Called at the beginning of installation of JavaEEServiceEngine Binding .
     * For this JavaEEServiceEngine, all the required installation tasks have
     * been taken care by the InstallationService.
     *
     * @throws javax.jbi.JBIException when there is an error requiring that the
     *         installation be terminated.
     */
    public void onInstall() throws JBIException {
    }

    /**
     * Called at the beginning of uninstallation of JavaEEServiceEngineBinding . 
     * For this JavaEEServiceEngine, all the required uninstallation tasks
     * have been taken care of by the InstallationService
     *
     * @throws javax.jbi.JBIException when there is an error requiring that the
     *         uninstallation be terminated.
     */
    public void onUninstall() throws JBIException {
    }
}
