/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.config;

/** 
 * This exception class represents Configuration errors. 
 * 
 * @author Sridatta Viswanath
 */

public class ConfigRuntimeException extends RuntimeException {

    /** used to keep the unlocalized code
     */
     private String _code = null;
     
     public ConfigRuntimeException(Throwable cause) {
        super(cause);
    }
        
    /** 
     * 
     * @param the exception message.
     */
     public ConfigRuntimeException(String message) {
	super(message);
    }
    
     public ConfigRuntimeException(String message, Throwable cause) {
           super(message + "\ncause: " + (cause==null ? "not known" : cause.getMessage()), cause);
    }
    
     public ConfigRuntimeException(String code, String message, Throwable cause) {
           super(message + "\ncause: " + (cause==null ? "not known" : cause.getMessage()), cause);
           _code = code;
    }
   
     public String getCode() {
         return _code;
     }
}
