/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.config.clientbeans;

import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.SAXParseException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import java.io.FileInputStream;
import java.io.File;
import java.io.InputStream;

import java.util.logging.Logger;
import java.util.logging.Level;

//The RelativePathResolver is used to translate relative paths containing 
//embedded system properties (e.g. ${com.sun.aas.instanceRoot}/applications) 
//into absolute paths
import com.sun.enterprise.util.RelativePathResolver;

public class ClientBeansResolver extends DefaultHandler {

       
    public static final String SUN_ACC_DTD_PATH = 
        "/sun-application-client-container_1_2.dtd";
    
  
    //===========================================================
    // Resolver methods
    //===========================================================

    public InputSource resolveEntity(String publicID, String systemID) 
      throws SAXException {
        InputSource is = null;
        try {
            InputStream i = this.getClass().getResourceAsStream(SUN_ACC_DTD_PATH );          
            if( i!= null ) {
	        return new InputSource(i);
            }
            is =  new InputSource(
               new FileInputStream(
               new File(new java.net.URI(
                   RelativePathResolver.resolvePath(systemID)))));
        } catch(Exception e) {
            throw new SAXException("Cannot resolve ", e);
        }
        return is;
    }
}



