/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.web.AppListenerDescriptor;

/** 
 * Objects exhibiting this interface represent an event listener descriptor.
 * This represents the <listener-class> XML element defined in the
 * Servlet 2.3 spec.
 * @author Vivek Nagar
 */

public class AppListenerDescriptorImpl implements AppListenerDescriptor, 
					    java.io.Serializable
{
    private String listenerClass;
    
    /** The default constructor.
    */
    public AppListenerDescriptorImpl() {
    }
    
    /**
     * Create an instance of the descriptor with the specified listener class.
     * @param the listener class name.
     */
    public AppListenerDescriptorImpl(String clz) {
	this.listenerClass = clz;
    }
    
    /** 
     * Return the listener class. 
     * @return the listener class name or empty string if none.
     */
    public String getListener() {
	if (this.listenerClass == null) {
	    this.listenerClass = "";
	}
	return this.listenerClass;
    }
    
    /** 
     * Sets the listener class.
     * @param the listener class name.
     */
    public void setListener(String clz) {
	this.listenerClass = clz;
    }

    /** 
     * Test for equals 
     */
    public boolean equals(Object obj) {
	return (obj instanceof AppListenerDescriptorImpl)?
	    this.getListener().equals(
		((AppListenerDescriptorImpl)obj).getListener()) :
	    super.equals(obj);
    }

    /** 
     * A formatted version of the state as a String. 
     */
    public void print(StringBuffer toStringBuffer) {
        toStringBuffer.append("Listener Class ").append(this.getListener());
    }
}

