/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import com.sun.enterprise.deployment.xml.ConnectorTagNames;

/**
 * This class encapsulates the xml tags: description, auth-mech-type and
 * credential-interface in the connector specification.
 * @author Sheetal Vartak
 */
public class AuthMechanism extends Descriptor{

    private int authMechVal;
    private String credInterface;

    /**
     * Default constructor.
     */
    public AuthMechanism(){}

    /**
     * Initializes the data members.
     * @param description description
     * @param authMechVal authentication mechanism type.
     * @param credInterface credential interface type.
     */
    public AuthMechanism(String description, int authMechVal,
                         String credInterface) {
        super.setDescription(description);
      	this.authMechVal = authMechVal;
        this.credInterface = credInterface;
    }

    /**
     * Set the credential interface.
     * @param cred the interface.
     */
    public void setCredentialInterface(String cred) {
        credInterface = cred;
    }

    /**
     * Get the credential interface.
     * @return credInterface the interface.
     */
    public String getCredentialInterface() {
        return credInterface;
    }

   /** 
    * Get the description
    * @return description.
    */
    public String getDescription(){
        return super.getDescription();
    }

    /** 
     * Sets the description
     * @param description.
     */
    public void setDescription(String description){
        super.setDescription(description);
    }

   /** 
    * Get the auth-mech-type
    * @return authMechVal the authentication mechanism type
    */
    public String getAuthMechType() {
        if(authMechVal == PoolManagerConstants.BASIC_PASSWORD)
	    return ConnectorTagNames.DD_BASIC_PASSWORD;
        else
            return ConnectorTagNames.DD_KERBEROS;
    }
    
    /**
     * Get the authentication mechanism value.
     */
    public int getAuthMechVal() { 
        return authMechVal;
    }

    /**
     * Set the authentication mechanism value.
     */
    public void setAuthMechVal(int value) { 
        authMechVal = value;
    }

    /**
     * Set the authentication mechanism value.
     */
    public void setAuthMechVal(String value) { 
        if((value.trim()).equals(ConnectorTagNames.DD_BASIC_PASSWORD))
	    authMechVal = PoolManagerConstants.BASIC_PASSWORD;
        else if((value.trim()).equals(ConnectorTagNames.DD_KERBEROS))
	    authMechVal = PoolManagerConstants.KERBV5;
	else throw new IllegalArgumentException("Invalid auth-mech-type");// put this in localStrings...
    }
}
