/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
 package com.sun.enterprise.deployment;

import java.lang.reflect.Field;

/** 
 * I represent a field on an ejb.
 * Either an actual field (e.g. for EJB1.1 CMP)
 * or a virtual field (e.g. for EJb2.0 CMP)
 *
 * @author Danny Coward
 */

public class FieldDescriptor extends Descriptor {

    /**
    * Constructrs an empty field descriptor 
    */
    public FieldDescriptor() {
    }    
    
    /**
    * Constructrs a field descriptor with the given name.
    */
    public FieldDescriptor(String name) {
	super(name, "no description");
    }
    
    /**
    * Constructrs a field descriptor with the given name and description.
    */
    public FieldDescriptor(String name, String description) {
	super(name, description);
    }
    
    /**
    * Constructs a field descriptor from the supplied java.lang.reflect.Field object.
    */
    
    public FieldDescriptor(Field field) {
	this(field.getName(), "no description");
    }
    
    /** Equality iff the other objects is a field descriptor with the same name.
    */
    
    public boolean equals(Object object) {
	if (object instanceof FieldDescriptor) {
	    FieldDescriptor otherFieldDescriptor = (FieldDescriptor) object;
	    return otherFieldDescriptor.getName().equals(this.getName());
	}
	return false;
    }
    
    /** My hashcode.
    */
    
    public int hashCode() {
	return this.getName().hashCode();
    }
    
    /**
    * Returns a formatted version of me as a String.
    */
    
    public void print(StringBuffer toStringBuffer) {
	toStringBuffer.append("Field: ").append(super.getName()).append("@").append(super.getDescription());
    }

    /**
     * <p>
     * Check if a field name is of an acceptable value (start with a lowercase
     * letter)
     * </p>
     * @param fieldName is the field name to test
     * @throw IllegalArgumentException if the name is unacceptable
     */
    public static void checkFieldName(String fieldName) throws IllegalArgumentException {
        
        if (fieldName == null || fieldName.length()==0) {
            throw new IllegalArgumentException("cmp-field or cmr-field name cannot be empty strings");
        }
        char firstChar = fieldName.charAt(0);
        if (!Character.isLetter(firstChar)) {
            throw new IllegalArgumentException("cmp-field or cmr-field name " + fieldName + " must begin with a letter ");
        }
        if (!Character.isLowerCase(firstChar)) {
            throw new IllegalArgumentException("cmp-field or cmr-field name " + fieldName + " must begin with a lowercase letter");
        }        
    }    
}
