/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment;

import java.util.logging.*;
import com.sun.logging.*;

import java.util.Map;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.List;
import java.util.LinkedList;

import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.deployment.util.LogDomains;


/**
 * Contains a single interceptor binding entry.
 */ 
public class InterceptorBindingDescriptor extends Descriptor
{
    private static LocalStringManagerImpl localStrings =
	    new LocalStringManagerImpl(InterceptorBindingDescriptor.class);

    static Logger _logger = LogDomains.getLogger(LogDomains.DPL_LOGGER);

    public enum BindingType {
        
        DEFAULT,
        CLASS,
        METHOD

    }

    // Only applies to CLASS and METHOD
    private String ejbName;

    // Only applies to METHOD
    private MethodDescriptor businessMethod;

    // Ordered list of interceptor classes.
    private LinkedList<String> interceptors = new LinkedList<String>();

    // True if interceptor list represents a total ordering.  
    private boolean isTotalOrdering;
    
    // Only applies to CLASS or METHOD
    private boolean excludeDefaultInterceptors;

    // Only applies to METHOD
    private boolean excludeClassInterceptors;

    private boolean needsOverloadResolution;

    public InterceptorBindingDescriptor() {
    }

    public BindingType getBindingType() {
        if( ejbName.equals("*") ) {
            return BindingType.DEFAULT;
        } else if( businessMethod == null ) {
            return BindingType.CLASS;
        } else {
            return BindingType.METHOD;
        }
    }

    public void setNeedsOverloadResolution(boolean flag) {
        needsOverloadResolution = flag;
    }

    public boolean getNeedsOverloadResolution() {
        return needsOverloadResolution;
    }

    public void setEjbName(String ejb) {
        ejbName = ejb;
    }

    public String getEjbName() {
        return ejbName;
    }

    public void setBusinessMethod(MethodDescriptor desc) {
        businessMethod = desc;
    }

    public MethodDescriptor getBusinessMethod() {
        return businessMethod;
    }

    public void appendInterceptorClass(String interceptor) {
        interceptors.addLast(interceptor);
    }
    
    public List<String> getInterceptorClasses() {
        return new LinkedList<String>(interceptors);
    }

    public void setIsTotalOrdering(boolean flag) {
        isTotalOrdering = flag;
    }

    public boolean getIsTotalOrdering() {
        return isTotalOrdering;
    }

    public void setExcludeDefaultInterceptors(boolean flag) {
        excludeDefaultInterceptors = flag;
    }

    public boolean getExcludeDefaultInterceptors() {
        return excludeDefaultInterceptors;
    }

    public void setExcludeClassInterceptors(boolean flag) {
        excludeClassInterceptors = flag;
    }

    public boolean getExcludeClassInterceptors() {
        return excludeClassInterceptors;
    }
    
}
