/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment;

import java.lang.reflect.Method;

/**
 * Deployment object representing the lifecycle-callback.
 *
 * @author Shing Wai Chan
 */
public class LifecycleCallbackDescriptor extends Descriptor {

    private String lifecycleCallbackClass;
    private String lifecycleCallbackMethod;
    private String defaultLifecycleCallbackClass;

    public enum CallbackType {

        POST_CONSTRUCT,
        PRE_DESTROY,
        PRE_PASSIVATE,
        POST_ACTIVATE 

    }

    public void setLifecycleCallbackClass(String clazz) {
        lifecycleCallbackClass = clazz;
    }

    public String getLifecycleCallbackClass() {
        if (lifecycleCallbackClass == null || 
            lifecycleCallbackClass.trim().equals("")) {
            return defaultLifecycleCallbackClass;
        } else {
            return lifecycleCallbackClass;
        }
    }

    public void setDefaultLifecycleCallbackClass(String clazz) {
        defaultLifecycleCallbackClass = clazz;
    }

    public String getDefaultLifecycleCallbackClass() {
        return defaultLifecycleCallbackClass;
    }

    public void setLifecycleCallbackMethod(String method) {
        lifecycleCallbackMethod = method;
    }

    public String getLifecycleCallbackMethod() {
        return lifecycleCallbackMethod;
    }

    /**
     * Given a classloader, find the Method object corresponding to this
     * lifecycle callback.  
     *
     * @throw Exception if no method found
     */
    public Method getLifecycleCallbackMethodObject(ClassLoader loader) 
        throws Exception {

        Method m = null;

        if( getLifecycleCallbackClass() == null ) {
            throw new IllegalArgumentException("no lifecycle class defined");
        }

        Class clazz = loader.loadClass(getLifecycleCallbackClass());
        
        // Check for the method within this class only.
        // This does not include super-classses.
        for(Method next : clazz.getDeclaredMethods()) {
            
            // Overloading is not allowed for AroundInvoke or
            // Callback methods so match by name only.
            if( next.getName().equals(lifecycleCallbackMethod) ) {
                m = next;
                break;
            }
        }

        if( m == null ) {
            throw new NoSuchMethodException("no method matching " +
                                            lifecycleCallbackMethod);
        }

        return m;
    }
}
