/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.deployment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

/**
 * A persistence.xml file can contain one or more <persistence-unit>s
 * This class represents information about a <persistence-unit>.
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class PersistenceUnitDescriptor extends Descriptor {

    private PersistenceUnitsDescriptor parent;

    private String name;

    private String transactionType = "JTA"; // in persistence.xsd default is JTA

    private String description;

    private String provider;

    private String jtaDataSource;

    private String nonJtaDataSource;

    private List<String> mappingFiles = new ArrayList<String>();

    private List<String> jarFiles = new ArrayList<String>();

    private List<String> classes = new ArrayList<String>();

    private Properties properties = new Properties();

    private boolean excludeUnlistedClasses = false;

    public PersistenceUnitDescriptor() {
    }

    public PersistenceUnitsDescriptor getParent() {
        return parent;
    }

    protected void setParent(PersistenceUnitsDescriptor parent) {
        assert(this.parent==null);
        this.parent = parent;
    }

    // NOW let's implement some methods specific to this descriptor
    // Most of these setter methods are invoked using reflection
    // by PersistenceNode. So any change here has to be reflcted there as
    // well. Compiler won't catch them for you.

    public String getName() {
        return name;
    }

    public void setName(String value) {
        this.name = value;
        this.changed();
    }

    public String getTransactionType() {
        return transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProvider() {
        return provider;
    }

    public void setProvider(String value) {
        this.changed();
        this.provider = value;
    }

    public String getJtaDataSource() {
        return jtaDataSource;
    }

    public void setJtaDataSource(String value) {
        this.jtaDataSource = value;
        this.changed();
    }

    public String getNonJtaDataSource() {
        return nonJtaDataSource;
    }

    public void setNonJtaDataSource(String value) {
        this.nonJtaDataSource = value;
        this.changed();
    }

    public List<String> getMappingFiles() {
        return Collections.unmodifiableList(mappingFiles);
    }

    public void addMappingFile(String mappingFile) {
        mappingFiles.add(mappingFile);
    }

    public List<String> getJarFiles() {
        return Collections.unmodifiableList(jarFiles);
    }

    public void addJarFile(String jarFile) {
        jarFiles.add(jarFile);
        this.changed();
    }

    public List<String> getClasses() {
        return Collections.unmodifiableList(classes);
    }

    public void addClass(String className) {
        classes.add(className);
        this.changed();
    }

    public Properties getProperties() {
        return (Properties) properties.clone();
    }

    public void addProperty(String name, Object value) {
        properties.put(name, value);
        this.changed();
    }

    public boolean isExcludeUnlistedClasses() {
        return excludeUnlistedClasses;
    }

    public void setExcludeUnlistedClasses(boolean excludeUnlistedClasses) {
        this.excludeUnlistedClasses = excludeUnlistedClasses;
    }

    public ClassLoader getClassLoader() {
        return getParent().getClassLoader();
    }

    public String getPuRoot() {
        return parent.getPuRoot();
    }

    /**
     * @return the absolute path of the root of this persistence unit
     * @see #getPuRoot()
     * @see PersistenceUnitsDescriptor#getAbsolutePuRoot()
     */
    public String getAbsolutePuRoot() {
        return getParent().getAbsolutePuRoot();
     }
}
