/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.deployment.annotation.context;

import java.lang.annotation.ElementType;
import java.lang.reflect.AnnotatedElement;

import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.annotation.ProcessingContext;

/**
 * This provides a context for a collection of web components with the same
 * impl class name.
 *
 * @author Shing Wai Chan
 */
public class WebComponentsContext extends AnnotationContext
            implements ComponentContext {

    private WebComponentContext[] webCompContexts;
    private String componentClassName;

    public WebComponentsContext(WebComponentDescriptor[] webComps) {
        webCompContexts = new WebComponentContext[webComps.length];
        for (int i = 0; i < webComps.length ; i++) {
            webCompContexts[i] = new WebComponentContext(webComps[i]);
        }
        if (webComps[0].isServlet()) {
            componentClassName = webComps[0].getWebComponentImplementation();
        }
    }
   
    /**
     * Create a new instance of WebComponentContext.
     * Note that, for performance, we don't make a safe copy of array here.
     */
    public WebComponentsContext(WebComponentContext[] webCompContexts) {
        this.webCompContexts = webCompContexts;
        this.componentClassName = webCompContexts[0].getComponentClassName();
    }

    /**
     * Note that, for performance, we don't make a safe copy of array here.
     */
    public WebComponentContext[] getWebComponentContexts() {
        return webCompContexts;
    }
    
    public void endElement(ElementType type, AnnotatedElement element) {
        
        if (ElementType.TYPE.equals(type)) {
            // done with processing this class, let's pop this context
            getProcessingContext().popHandler();
        }
    }

    public String getComponentClassName() {
        return componentClassName;
    }
}
