/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.deployment.annotation.factory;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

import javax.enterprise.deploy.shared.ModuleType;

import com.sun.enterprise.deployment.annotation.impl.AppClientScanner;
import com.sun.enterprise.deployment.annotation.impl.EjbJarScanner;
import com.sun.enterprise.deployment.annotation.impl.WarScanner;
import com.sun.enterprise.deployment.annotation.Scanner;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.deploy.shared.AbstractArchive;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;

/**
 * The Factory is reponsible for creating Scanner.
 *
 * @author Shing Wai Chan
 */
public class ScannerFactory {
    private ScannerFactory() {
    }

    public static Scanner createScanner(BundleDescriptor bundleDesc,
            Archivist archivist, AbstractArchive abstractArchive,
            ClassLoader classLoader) throws IOException {
        Scanner scanner = null;
        File f = new File(abstractArchive.getArchiveUri());

        if (ModuleType.EJB.equals(archivist.getModuleType())) {
            scanner = new EjbJarScanner(f, (EjbBundleDescriptor)bundleDesc,
                   classLoader);
        } else if (ModuleType.WAR.equals(archivist.getModuleType())) {
            scanner = new WarScanner(f, (WebBundleDescriptor)bundleDesc,
                   classLoader);
        } else if (ModuleType.CAR.equals(archivist.getModuleType())) {
            ApplicationClientDescriptor appClientDesc =
                    (ApplicationClientDescriptor)bundleDesc;

            scanner = new AppClientScanner(f, appClientDesc, classLoader);
        }

        return scanner;
    }
}
